% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_scale_with_blueprint.R
\name{build_scale_with_blueprint}
\alias{build_scale_with_blueprint}
\title{Construct Forced-Choice Blocks Aligned with the Specifications in a Blueprint}
\usage{
build_scale_with_blueprint(
  item_df,
  blueprint,
  bp_block_name,
  bp_item_nums_name,
  bp_trait_name,
  bp_sign_name,
  bp_matching_criterion_name,
  df_item_nums_name,
  df_trait_name,
  df_sign_name,
  df_matching_criterion_name,
  df_matching_function,
  df_matching_adjust_factor,
  max_attempts_in_comb = 100,
  max_attempts_in_adjust
)
}
\arguments{
\item{item_df}{Data frame containing information related to all the available items}

\item{blueprint}{Pre-specified blueprint for your blocks. Preferably constructed from \code{construct_blueprint()}}

\item{bp_block_name, bp_item_nums_name, bp_trait_name, bp_sign_name}{Column names in the blueprint that specifies block number, item number in the block, desired trait of the item, and desired keying of the item, respectively}

\item{bp_matching_criterion_name}{Column name in the blueprint that indicates the additional matching criterion (cutoff value) you wish to test}

\item{df_item_nums_name, df_trait_name, df_sign_name, }{Column names in \code{item_df} that specifies item_number, trait of the item, and keying of the item, respectively}

\item{df_matching_criterion_name}{Optional. Column name in \code{item_df} that is used to evaluate the matching criterion specified in \code{bp_matching_criterion_name}}

\item{df_matching_function}{Optional. A character string containing function name for evaluating the matching criterion}

\item{df_matching_adjust_factor}{Optional. A numeric value. If after \code{max_attempts_in_comb} attempts the additional
criteria in \code{df_matching_criterion_name} cannot be met (> the cutoff value specified in \code{blueprint[, bp_matching_criterion_name]}), 
multiply that cutoff value by this adjusting factor.}

\item{max_attempts_in_comb}{Optional. An integer value. How many attempts will be made for finding a block that satisfies the blueprint, before we adjust the cutoff value?}

\item{max_attempts_in_adjust}{Optional. An integer value. How many attempts will be made for adjusting cutoff value? 
Will throw a warning and return the currently partially constructed scale (and specify which block might have problems) if number of attempts exceeds this value.}
}
\value{
A data frame containing the selected items for each specified block.
If matching criteria is specified, the data frame will also contain the number of
times we adjusted the cutoffs for each block, and the final matching criteria cutoff
resulting from adjustments.
}
\description{
This function takes in the information of all available items as well as
a blueprint data frame specifying the design of blocks, and returns a data frame of item
blocks consistent with the blueprint (if possible).
}
\details{
Although automatically finding the block combinations that can satisfy
multiple certain criteria for matching can be helpful (as the primary functionality of the previous
version of \code{autoFC} is about), users may also wish to have exact specifications for some blocks in many cases. 
For example, typically in FC construction, we may want to explicitly specify the trait and keying combinations
for each block. This function allows you to explicitly do that. Users are free to extend this function if further
exact specifications are needed.

For now, this function also allows users to specify one additional matching criterion for
the blocks. Users can designate the function for calculating this criterion (\code{df_matching_function}) and specify
a multiplicative adjusting factor (\code{df_matching_adjust_factor}), 
if the criterion fails to be met after a specified number of attempts (\code{max_attempts_in_comb}).
One good example of matching criterion is matching in social desirability rating, where you want ratings of the items in the same block
to be less than a certain cutoff.

If after a certain number of times (\code{max_attempts_in_adjust}) the given block is still unable to be constructed 
(i.e., criterion matching still fails even if we relax the cutoff multiple times), a warning message will be shown
and a partially built scale will be returned. Warnings along with a partially built scale may also be returned 
when it is impossible for the remaining items in \code{item_df} to satisfy the specification in the blueprint
 (e.g. we have no items for trait1 left, but the blueprint requires a block with an item measuring trait1).
}
\examples{
#### For the case you do not need additional matching criterion
item_info <- triplet_block_info
test_bp <- construct_blueprint(N_blocks = 2, block_size = 3, 
                               traits = c("honestyhumility", "emotionality", "extraversion",
                                          "agreeableness", "conscientiousness", "openness"),
                               signs = c(-1, 1, 1,
                                         -1, -1, -1))
### Some arguments can be omitted if you don't have extra matching criteria.
picked_scale <- build_scale_with_blueprint(item_df = item_info,
                                           blueprint = test_bp,
                                           ### These parameters are column names in test_bp
                                           bp_block_name = "block",
                                           bp_item_nums_name = "item_num",
                                           bp_trait_name = "traits",
                                           bp_sign_name = "signs",
                                           ### These parameters are column names in item_info
                                           df_item_nums_name = "ID",
                                           df_trait_name = "Factor",
                                           df_sign_name = "Keying")

#### Or you may want to match social desirability ratings, for example
test_bp2 <- test_bp
test_bp2$SD_matching <- rep(0.5, 6)

#### Suppose that the items also have their own ratings
item_info2 <- item_info
item_info2$SD_rating <- rnorm(15, 3.5, 1)
range_m <- function(x) {
  return(max(x) - min(x))
}

picked_scale2 <- build_scale_with_blueprint(item_df = item_info2,
                                            blueprint = test_bp2,
                                            ### These parameters are column names in test_bp2
                                            bp_block_name = "block",
                                            bp_item_nums_name = "item_num",
                                            bp_trait_name = "traits",
                                            bp_sign_name = "signs",
                                            ### These parameters are column names in item_info2
                                            df_item_nums_name = "ID",
                                            df_trait_name = "Factor",
                                            df_sign_name = "Keying",
                                            ### These parameters will be used 
                                            ### when you have extra matching criteria
                                            df_matching_criterion_name = "SD_rating",
                                            bp_matching_criterion_name = "SD_matching",
                                            ## Which function is used to calculate matching?
                                            df_matching_function = "range_m",
                                            df_matching_adjust_factor = 1.25,
                                            max_attempts_in_comb = 100,
                                            max_attempts_in_adjust = 20)

}
\seealso{
\code{construct_blueprint()}
}
\author{
Mengtong Li
}
