% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invert_names.R
\name{invert_names}
\alias{invert_names}
\title{Invert 'LastName FirstName' to 'FirstName LastName' (or the reverse)}
\usage{
invert_names(names, correct_names)
}
\arguments{
\item{names}{A character vector of potentially inverted names}

\item{correct_names}{A character vector of correct names}
}
\value{
A character vector with the same length as \code{names}
}
\description{
Invert 'LastName FirstName' to 'FirstName LastName' (or the reverse)
}
\details{
When you have a list \code{x} of mixed 'First Last' and 'Last First' names, but no
source of truth and you want to deduplicate them, this function can be used
as \code{expand_names(x, x)}, which will return the most common version available
in \code{x} for each name.
}
\examples{
invert_names(
  c("Wolfgang Mozart", "Mozart Wolfgang"),
  "Wolfgang Mozart"
)

# Real-case application example
# Deduplicate names in list, as described in "details"
epi_pkg_authors <- cran_epidemiology_packages |>
  subset(!is.na(`Authors@R`), `Authors@R`, drop = TRUE) |>
  parse_authors_r() |>
  # Drop email, role, ORCID and format as string rather than person object
  lapply(function(x) format(x, include = c("given", "family"))) |>
  unlist()

# With all duplicates
length(unique(epi_pkg_authors))

# Deduplicate
epi_pkg_authors_normalized <- invert_names(epi_pkg_authors, epi_pkg_authors)

length(unique(epi_pkg_authors_normalized))

}
