% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_plot_distrib_3D.R
\name{f_plot_distrib_3D}
\alias{f_plot_distrib_3D}
\title{Plot of historical distributions in 3D}
\usage{
f_plot_distrib_3D(
  m_param_histo,
  type_function,
  v_date = NULL,
  n_samples = 10000,
  x_min = NULL,
  x_max = NULL,
  x_lab,
  y_lab,
  color_theme = c("#bd8e42", "#bebfbf")
)
}
\arguments{
\item{m_param_histo}{Numeric matrix containing the parameters of the f_param_histo function}

\item{type_function}{String argument specifying the distribution type ("gaussian", "skew-gaussian" or "skew-t")}

\item{v_date}{Vector optional of dates containing the full sample's dates (default value : daily dates starting from "1970-01-01")}

\item{n_samples}{Number optional of samples for the plot (default value = 1000)}

\item{x_min}{Numeric optional argument (default value = VaR 97.5)}

\item{x_max}{Numeric optional argument (default value = VaR 2.5)}

\item{x_lab}{String optional argument for the x axis title (default value = x)}

\item{y_lab}{String optional argument for the y axis title (default value = y)}

\item{color_theme}{A character vector specifying the color theme to use (default value c("#bd8e42", "#bebfbf"))}
}
\value{
A plot in 3D of historical distributions
}
\description{
This function allows to create a plot in 3D of historical distributions.
}
\examples{
# Import data
data(data_US)

data(data_param_histo_US)

results_plot_3D <- f_plot_distrib_3D(m_param_histo=data_param_histo_US,
type_function="skew-t",
v_date=data_US[,1],
x_lab="US GDP variation",
y_lab="Year")
}
