% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostic_plots.R
\name{plot_cook}
\alias{plot_cook}
\title{Plot Cook's distances}
\usage{
plot_cook(
  model,
  n_highlights = 0,
  cut = FALSE,
  xlab = "Index",
  ylab = "Cook's distance",
  ...
)
}
\arguments{
\item{model}{Model with \code{\link[=cooks.distance]{cooks.distance()}} method}

\item{n_highlights}{The number of observations with the highest Cook's
distance to highlight on the plot. Defaults to 0 (no highlights).}

\item{cut}{Logical. If TRUE, adds a cutoff line at the mean plus four times
the standard deviation of Cook's distance. Defaults to FALSE.}

\item{xlab}{The label for the x-axis. Defaults to "Index".}

\item{ylab}{The label for the y-axis. Defaults to "Cook's distance".}

\item{...}{Further arguments for \code{\link[graphics:plot.default]{graphics::plot()}}}
}
\value{
An invisible object representing Cook's distance values.
}
\description{
Plot Cook's distances
}
\examples{
fit <- lm(mpg ~ cyl, data = mtcars)

plot_cook(fit)
plot_cook(fit, n_highlights = 2)

}
\seealso{
\code{\link{cooks.distance}}, \code{\link{plot}}
}
