% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_wald_pvalues.R
\name{plot.AD_pvalues}
\alias{plot.AD_pvalues}
\title{Plot Empirical Cumulative Distribution Function (ECDF) of p-values}
\usage{
\method{plot}{AD_pvalues}(
  x,
  which = seq_len(length(x$test_coefficients) + 1),
  caption = as.list(paste("ECDF of", c(names(x$test_coefficients), "all coefficients"))),
  ks_test = TRUE,
  signif = c(0.01, 0.05, 0.1),
  discrepancy_tol = 0.1,
  plot_uniform = TRUE,
  uniform_legend = TRUE,
  converged_only = FALSE,
  no_warnings = FALSE,
  no_messages = FALSE,
  ylab = "Empirical cumulative distribution",
  xlab = "p-value",
  ...,
  ask = prod(graphics::par("mfcol")) < length(which) && grDevices::dev.interactive()
)
}
\arguments{
\item{x}{AD_pvalues object, usually the result of \code{\link[=simulate_wald_pvalues]{simulate_wald_pvalues()}}}

\item{which}{A vector specifying the indices of coefficients to plot.
If index is bigger than the number of coefficients it plots the joint p_value.}

\item{caption}{A character vector or a list with caption for each plot.
If it's a list, the list index must match the coefficient index used by \code{which}.
If it's a vector, it's values are used in order.}

\item{ks_test}{If \code{TRUE} inserts Kolmogorov-Smirnov p-value in the graphic.}

\item{signif}{Points to verify discrepancy.}

\item{discrepancy_tol}{Threshold to consider point discrepant.}

\item{plot_uniform}{Logical. If TRUE, plot uniform distribution.}

\item{uniform_legend}{Logical. If TRUE, a legend is added to the plot to
distinguish between the p-value and U(0, 1) curves. Defaults to TRUE.}

\item{converged_only}{Use p-values from converged models only.}

\item{no_warnings}{If TRUE, ignore simulations that threw warnings.}

\item{no_messages}{If TRUE, ignore simulations that shown messages.}

\item{ylab}{The label for the y-axis. Defaults to "Empirical cumulative distribution".}

\item{xlab}{The label for the x-axis. Defaults to "p-value".}

\item{...}{extra arguments passed to \link[graphics:plot.default]{graphics::plot}}

\item{ask}{Logical. If TRUE, the user is prompted before each plot. Defaults
to TRUE if in an interactive session and the number of plots is greater
than the available space; otherwise, FALSE.}
}
\value{
A vector of joint p-values for all coefficients.
}
\description{
This function creates several plots with the empirical cumulative distribution
of the p-values obtained through simulation.
}
\details{
If the asymptotic approximation is valid the distribution of the p-values
should be close to an uniform distribution.
Discrepancies are highlighted, by default it verifies the significance on the
most commonly used significance values are 0.01, 0.05 and 0.10.

The reported KS (Kolmogorov-Smirnov) test is the result of the "two-sided" \code{\link[stats:ks.test]{stats::ks.test()}} function
comparing the observed p-values distribution with the uniform.
The test may reject the KS test due to few simulations, make sure that the lines
shown in the plot are smooth before drawing any conclusions.
}
\examples{
model <- lm(mpg ~ wt + hp, data = mtcars)
p_values_ld <- simulate_wald_pvalues(model, n_sim = 100)
plot(p_values_ld)
}
