% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_type.R
\name{assert_number}
\alias{assert_number}
\title{Assert input is a number}
\usage{
assert_number(x, msg = NULL, call = rlang::caller_env(), arg_name = NULL)
}
\arguments{
\item{x}{An object}

\item{msg}{A character string containing the error message to display if x is not a number}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if x is a number, otherwise aborts with the error message specified by msg
}
\description{
A number is a length 1 numeric vector.
Numbers can be either integers or doubles.
}
\examples{
assert_number(2) # Passes
try({
assert_number(c(2, 3)) # Throws default error
assert_number("a") # Throws default error
assert_number(c("a", 1, "b"), "Custom error message") # Throws custom error
})


}
\concept{assert_type}
