% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_functions.R
\name{assert_function_expects_n_arguments}
\alias{assert_function_expects_n_arguments}
\title{Assert function expects n arguments}
\usage{
assert_function_expects_n_arguments(
  x,
  n,
  dots = c("throw_error", "count_as_0", "count_as_1", "count_as_inf"),
  msg = NULL,
  call = rlang::caller_env(),
  arg_name = NULL
)
}
\arguments{
\item{x}{a function to check has exactly N arguments}

\item{n}{number of arguments that must be expected by function to pass assertion (integer)}

\item{dots}{how to deal with '...' dots (a.k.a variable arguments). Should we count as 0, 1 or infinite arguments. Or, do we just throw an error when we see '...' (default)}

\item{msg}{The error message thrown if the assertion fails (string)}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if function \code{x} expects exactly n arguments, otherwise aborts with the error message specified by \code{msg}
}
\description{
Assert a function expects n arguments, with user control over how variable arguments (...) are counted (default throws error)
}
