% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_type.R
\name{assert_dataframe}
\alias{assert_dataframe}
\title{Assert input is a data frame}
\usage{
assert_dataframe(x, msg = NULL, call = rlang::caller_env(), arg_name = NULL)
}
\arguments{
\item{x}{An object}

\item{msg}{A character string containing the error message to display if \code{x} is not a data frame}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if \code{x} is a data frame, otherwise aborts with the error message specified by \code{msg}
}
\description{
Assert input is a data frame
}
\examples{
try({
assert_dataframe(mtcars) # Passes
assert_dataframe(data.frame()) # Passes

assert_dataframe(1:10) # Throws default error
assert_dataframe(matrix(1:6, 2, 3)) # Throws default error
assert_dataframe(c(1, 2, 3)) # Throws default error: "Error
assert_dataframe(list(a = 1, b = 2)) # Throws default error
assert_dataframe(factor(c(1, 2, 3))) # Throws default error

assert_dataframe(1:10, msg = "Custom error message") # Throws custom error
})


}
\concept{assert_type}
