% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asm.R
\name{summary.asm}
\alias{summary.asm}
\title{Summary of an \code{asm} regression model}
\usage{
\method{summary}{asm}(object, ...)
}
\arguments{
\item{object}{asm object}

\item{...}{additional arguments to ensure compatibility with the generic function summary()}
}
\value{
\code{summary.asm} class object containing the following components:
\describe{
 \item{\code{coefficients}:}{estimated coefficients, standard errors, z-values and p-values}
 \item{\code{residuals}:}{residuals of the fitted model}
 \item{\code{call}:}{call to the \code{asm} function}
}
}
\description{
Outputs estimated coefficients, standard errors and p-values based on a fitted \code{asm} regression model
}
\examples{
model = asm(mpg ~ cyl + hp + disp, data=mtcars)
summary(model)
}
