% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asm.R
\name{asm}
\alias{asm}
\title{Linear regression via antitonic score matching}
\usage{
asm(formula, data = NULL, ...)
}
\arguments{
\item{formula}{regression formula}

\item{data}{input data frame}

\item{...}{additional arguments for asm.fit}
}
\value{
\code{asm} class object containing the following components:
\describe{
 \item{\code{betahat}:}{vector of estimated coefficients}
 \item{\code{std_errs}:}{vector of standard errors of the estimated coefficients}
 \item{\code{fitted.values}:}{fitted values}
 \item{\code{residuals}:}{residuals}
 \item{\code{zvals}:}{z-values}
 \item{\code{sig_vals}:}{p-values}
 \item{\code{info_asm}:}{antitonic information}
 \item{\code{I_mat}:}{estimated antitonic information matrix}
 \item{\code{Cov_mat}:}{covariance matrix of the estimated coefficients}
 \item{\code{psi}:}{estimated antitonic score function}
}
}
\description{
Performs linear regression with a data-driven convex loss function
}
\examples{
asm(mpg ~ cyl + hp + disp, data=mtcars)

asm(mpg ~ cyl + hp + disp, data=mtcars, symmetric=FALSE)

n <- 1000 ; d <- 2
X <- matrix(rnorm(n * d), n, d)
Y <- X \%*\% c(2, 3) + 1 + rnorm(n)
asm(Y ~ X - 1)

Y <- X \%*\% c(2, 3) + rchisq(n, 6) - qchisq(0.4, 6)
asm(Y ~ X, symmetric=FALSE, intercept.selection="quantile", error_quantile=0.4)

Y <- X \%*\% c(2, 3) + rcauchy(n)
asm(Y ~ X, symmetric=FALSE, intercept.selection="median")

}
