% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_lambda_feasibility.R
\name{is.lambda.feasible.LOO}
\alias{is.lambda.feasible.LOO}
\title{Check the feasibility of a tuning parameter \eqn{\lambda} for LOO algorithm.}
\usage{
is.lambda.feasible.LOO(
  lambda,
  scaled.difference.matrix,
  sample.mean = NULL,
  threshold = 0.08,
  n.pairs = 100,
  seed = NULL
)
}
\arguments{
\item{lambda}{The real-valued tuning parameter for exponential weightings (the calculation of softmin).}

\item{scaled.difference.matrix}{A n by (p-1) difference scaled.difference.matrix matrix after column-wise scaling (reference dimension - the rest);
each of its row is a (p-1)-dimensional vector of differences.}

\item{sample.mean}{The sample mean of the n samples in scaled.difference.matrix; defaults to NULL. It can be calculated via colMeans(scaled.difference.matrix).
If your experiment involves hypothesis testing over more than one dimension, pass sample.mean=colMeans(scaled.difference.matrix) to speed up computation.}

\item{threshold}{A threshold value to examine if the first order stability is likely achieved; defaults to 0.08. As its value gets smaller, the first order stability tends to increase while power might decrease.}

\item{n.pairs}{The number of \eqn{(i,j)} pairs for estimation; defaults to 100.}

\item{seed}{(Optional) An integer-valued seed for subsampling.}
}
\value{
A boolean value indicating if the given \eqn{\lambda} likely gives the first order stability.
}
\description{
Check the feasibility of a tuning parameter \eqn{\lambda} for LOO algorithm by examining
whether its resulting \eqn{\nabla_i K_j} is less than a threshold value,
i.e., the first order stability is likely achieved.
For further details, we refer to the paper Zhang et al 2024.
}
