% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.R
\name{impute}
\alias{impute}
\title{Missing value imputation with ARF}
\usage{
impute(
  x,
  m = 1,
  expectation = ifelse(m == 1, TRUE, FALSE),
  num_trees = 100L,
  min_node_size = 10L,
  round = TRUE,
  finite_bounds = "local",
  epsilon = 1e-14,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{Input data.}

\item{m}{Number of imputed datasets to generate. The default is single
imputation (\code{m = 1}).}

\item{expectation}{Return expected value instead of multiple imputations. By
default, for single imputation (\code{m = 1}), the expected value is
returned.}

\item{num_trees}{Number of trees to grow in the ARF.}

\item{min_node_size}{Minimal number of real data samples in leaf nodes.}

\item{round}{Round continuous variables to their respective maximum precision
in the real data set?}

\item{finite_bounds}{Impose finite bounds on all continuous variables? See
\code{\link{forde}}.}

\item{epsilon}{Slack parameter on empirical bounds; see \code{\link{forde}}.}

\item{verbose}{Print progress for \code{adversarial_rf}?}

\item{...}{Extra parameters to be passed to \code{adversarial_rf},
\code{forde} and \code{expct}/\code{forge}.}
}
\value{
Imputed data. A single dataset is returned for \code{m = 1}, a list
of datasets for \code{m > 1}.
}
\description{
Perform single or multiple imputation with ARFs. Calls \code{adversarial_rf},
\code{forde} and \code{expct}/\code{forge}.
}
\examples{
# Generate some missings
iris_na <- iris
for (j in 1:ncol(iris)) {
  iris_na[sample(1:nrow(iris), 5), j] <- NA
}

# Single imputation
iris_imputed <- arf::impute(iris_na, num_trees = 10, m = 1)

# Multiple imputation
iris_imputed <- arf::impute(iris_na, num_trees = 10, m = 10)

\dontrun{
# Parallelization with doParallel
doParallel::registerDoParallel(cores = 4)

# ... or with doFuture
doFuture::registerDoFuture()
future::plan("multisession", workers = 4)
}

}
\seealso{
\code{\link{arf}}, \code{\link{forde}}, \code{\link{forge}},
\code{\link{expct}}, \code{\link{lik}}
}
