% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_labels.R
\name{labels}
\alias{labels}
\title{Labels for model training}
\usage{
labels(
  data,
  label,
  relations = NULL,
  show_type = FALSE,
  show_tag = FALSE,
  show_ID = FALSE,
  handle_multiple = "duplicate"
)
}
\arguments{
\item{data}{character or WebAnnoTSV. The contents of a WebAnno TSV v3.3 file 
as created by \code{\link{webanno_open}} or a path leading to it.}

\item{label}{character. The main label. The relations must go FROM this term.}

\item{relations}{character. The set of relations you'd like to extract.}

\item{show_type}{logical. Add a column with the type of relation of the related terms.}

\item{show_tag}{logical. Add a column with the tags of the related terms.}

\item{show_ID}{logical. Add a column with the positional ID of the related terms.}

\item{handle_multiple}{character. If there are multiple \code{relations} connecting to the same \code{label},
i.e. multiples locations, show should it be handled? Should \code{duplicate} rows be created or the content be \code{merge}'d?}
}
\value{
A list of dataframes, organized with columns for the corresponding line in the text, label and relations (if \code{relations != NULL})
}
\description{
Extract the labels and relations in a webanno file to an easy, 
machine readable format ready for machine learning projects.
}
\examples{
example = arete_data("annotations")[[1]]
labels(data = example, label = "Species", relations = "OCCURS")

labels(data = example,
label = c("TraitVal"), relations = c("meas_Sex")) 

labels(data = example,
label = c("TraitVal"), relations = c("meas_trait", "meas_Sex", "meas_Unit"))

labels(data = example,
label = c("TraitVal"), relations = c("meas_trait", "meas_Sex", "meas_Unit"),
 handle_multiple = "merge")  
}
