% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_raster.R
\name{match_legend_colors}
\alias{match_legend_colors}
\title{Match colors in SpatRaster coltab to the provided legend values}
\usage{
match_legend_colors(legend, raster_cols)
}
\arguments{
\item{legend}{An object of class raster_legend as returned by
\code{\link{get_layer_legend}}}

\item{raster_cols}{The colortable from a SpatRaster object. Use the first
item in the list}
}
\value{
A raster_legend object with corrected colors to match those in
\code{x}
}
\description{
Colors provided by the legend do not always correspond exactly with the
colors in the coltab of a SpatRaster object. They are usually pretty
close, though, so this function finds the closest colors, maps them to the
appropriate colors in the Raster* object, and applies that to the legend.
}
\details{
Raster colors in \code{x} are mapped to those in \code{legend} by converting
the RGB hexadecimal values to a 3D vector of values for red, green and blue.
The closest values are then assigned using 3D Pythagorean theorem to compute
the distance among all colors. The minimum distance in three dimensional
space is the color in \code{x} that gets mapped to the appropriate color in
\code{legend}.
}
\examples{
\dontrun{
wi_landcover <- get_map_layer(wi_landcover_url, wis_poly)
legend <- get_layer_legend(wi_landcover_url)
new_legend <- match_legend_colors(legend, wi_landcover_url)
}

}
