% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modulation.R
\name{modulation}
\alias{modulation}
\title{Compute the modulation of cluster units}
\usage{
modulation(
  x,
  timeStep = "annual",
  synthesis = FALSE,
  by = c("cluster", "sector"),
  clusterDesc = NULL,
  opts = NULL
)
}
\arguments{
\item{x}{An \code{antaresData} object created with \code{readAntares}. It must
contain the hourly detailed results for clusters if \code{by = "cluster"}
or for areas and/or districts if \code{by = "sector"}}

\item{timeStep}{Desired time step for the result.}

\item{synthesis}{If TRUE, average surpluses are returned. Else the function returns surpluses
per Monte-Carlo scenario.}

\item{by}{Should modulations computed by cluster or by sector? Possible values are
"sector" and "cluster".}

\item{clusterDesc}{A table created with the function \code{\link[antaresRead]{readClusterDesc}}.
If is this parameter is set to \code{NULL} (the default), then the function
attempts to read the needed data in the same study as \code{x}.}

\item{opts}{opts where clusterDesc will be read if null based on data}
}
\value{
A data.table of class \code{antaresDataTable} or a list of such tables with
the following columns:
\item{area}{
  Area name. If \code{byDistrict=TRUE}, this column is replaced by column
  \code{district}.
}
\item{cluster}{
  Cluster name. If \code{by="sector"}, this column is replaced by column
  \code{sector}.
}
\item{timeId}{
  Time id and other time columns.
}
\item{upwardModulation}{
  Maximal absolute modulation of a cluster unit or of the sector, if \code{timeStep} is hourly.
}
\item{downwardModulation}{
  Maximal absolute modulation of a cluster unit or of the sector, if \code{timeStep} is hourly.
}
\item{absoluteModulation}{
  Maximal absolute modulation of a cluster unit or of the sector, if \code{timeStep} is hourly.
}
\item{avg_upwardModulation}{
  Average upward modulation of a cluster unit or of the sector, if \code{timeStep} is not hourly.
}
\item{avg_downwardModulation}{
  Average downward modulation of a cluster unit or of the sector, if \code{timeStep} is not hourly.
}
\item{avg_absoluteModulation}{
  Average absolute modulation of a cluster unit or of the sector, if \code{timeStep} is not hourly.
}
\item{max_upwardModulation}{
  Maximal upward modulation of a cluster unit or of the sector, if \code{timeStep} is not hourly.
}
\item{max_downwardModulation}{
  Maximal downward modulation of a cluster unit or of the sector, if \code{timeStep} is not hourly.
}
\item{max_absoluteModulation}{
  Maximal absolute modulation of a cluster unit or of the sector, if \code{timeStep} is not hourly.
}

Notice that if \code{by="cluster"}, the function computes the modulation per
unit, i.e. the modulation of a cluster divided by the number of units of the
cluster. On the opposite, if \code{by="sector"}, the function returns the
modulation of the global production of the sector. Moreover, if parameter
\code{x} contains area and district data, the function returns a list with
components \code{areas} and  \code{districts}.
}
\description{
This function computes the modulation of cluster units or of sectors.
}
\examples{
\dontrun{
# data required by the function
showAliases("modulation")

mydata <- readAntares(select="modulation")

# Modulation of cluster units
modulation(mydata)

# Aggregate Monte-Carlo scenarios
modulation(mydata, synthesis = TRUE)

# Modulation of sectors
modulation(mydata, by = "sector")

# Modulation of sectors per district
modulation(mydata, by = "sector")
}

}
