% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence_score_heatmap.R,
%   R/confidence_score_plots.R
\name{confidence_score_heatmap}
\alias{confidence_score_heatmap}
\title{Confidence Score Heat Map}
\usage{
confidence_score_heatmap(
  confidence_scores = NULL,
  data_outcomes = NULL,
  x_label = NULL
)

confidence_score_heatmap(
  confidence_scores = NULL,
  data_outcomes = NULL,
  x_label = NULL
)
}
\arguments{
\item{confidence_scores}{A data frame of confidence scores generated from the aggregation methods in the form of \link{data_confidence_scores}.
Defaults to \link{data_confidence_scores} if no argument supplied.}

\item{data_outcomes}{A data frame of unique claims and the associated binary outcome in the form of \link{data_outcomes}. If no argument supplied
then defaults to \link{data_outcomes} supplied within package.}

\item{x_label}{Bottom x axis label name or ID. Default is blank.}
}
\value{
Plot in viewer

Plot in viewer
}
\description{
Confidence scores displayed on a colour spectrum across generated methods and
assessed claims, split into predicted replication outcomes (TRUE/FALSE).

Confidence scores displayed on a colour spectrum across generated methods and assessed claims,
split into predicted replication outcomes (TRUE/FALSE). White indicative of around \code{.5} with higher predicted
confidence scores more blue (\verb{>.5}) and lower more red (\verb{<.5}). Each predicted replication outcome is then
split into the group type of the underlying statistical characteristic for each aggregation method (non-weighted linear,
weighted linear & Bayesian).
}
\examples{
\donttest{confidencescore_heatmap(data_confidence_scores, data_outcomes)}

\dontrun{confidencescore_heatmap(data_confidence_scores, data_outcomes)}

}
