% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isocubeGrob.r
\name{isocubeGrob}
\alias{isocubeGrob}
\alias{grid.isocube}
\title{Isometric cube grob}
\usage{
isocubeGrob(
  top,
  right,
  left,
  gp_border = grid::gpar(col = "black", lwd = 12),
  name = NULL,
  gp = grid::gpar(),
  vp = NULL
)

grid.isocube(...)
}
\arguments{
\item{top}{A grid grob object to use as the top side of the cube.  ggplot2 objects will be coerced by \code{\link[ggplot2:ggplotGrob]{ggplot2::ggplotGrob()}}.}

\item{right}{A grid grob object to use as the right side of the cube.  ggplot2 objects will be coerced by \code{\link[ggplot2:ggplotGrob]{ggplot2::ggplotGrob()}}.}

\item{left}{A grid grob object to use as the left side of the cube.  ggplot2 objects will be coerced by \code{\link[ggplot2:ggplotGrob]{ggplot2::ggplotGrob()}}.}

\item{gp_border}{A \code{\link[grid:gpar]{grid::gpar()}} object for the \code{\link[=polygonGrob]{polygonGrob()}} used to draw borders around
the cube faces.}

\item{name}{A character identifier (for grid).}

\item{gp}{A \code{\link[grid:gpar]{grid::gpar()}} object.}

\item{vp}{A \code{\link[grid:viewport]{grid::viewport()}} object (or \code{NULL}).}

\item{...}{Passed to \code{isocubeGrob()}}
}
\value{
A \code{\link[grid:grid.grob]{grid::gTree()}} (grob) object of class "isocube".
As a side effect \code{grid.isocube()} draws to the active graphics device.
}
\description{
\code{isometricCube()} is a grid grob function to render
isometric cube faces by automatically wrapping around \code{affineGrob()}.
}
\details{
Any \code{ggplot2} objects are coerced to grobs by \code{\link[ggplot2:ggplotGrob]{ggplot2::ggplotGrob()}}.  Depending on what you'd like
to do you may want to instead manually convert a ggplot2 object \code{gg} to a grob with \code{gtable::gtable_filter(ggplot2::ggplotGrob(gg), "panel")}.

Not all graphics devices provided by \code{grDevices} or other R packages support the \href{https://www.stat.auckland.ac.nz/~paul/Reports/GraphicsEngine/groups/groups.html}{affine transformation feature introduced in R 4.2}.
If \code{isTRUE(getRversion() >= '4.2.0')} then the active graphics device should support this feature if \code{isTRUE(grDevices::dev.capabilities()$transformations)}.
In particular the following graphics devices should support the affine transformation feature:
\itemize{
\item R's \code{\link[grDevices:pdf]{grDevices::pdf()}} device
\item R's 'cairo' devices e.g. \code{\link[grDevices:cairo]{grDevices::cairo_pdf()}}, \code{grDevices::png(type = 'cairo')}, \code{\link[grDevices:cairo]{grDevices::svg()}}, \code{grDevices::x11(type = 'cairo')}, etc. If \code{isTRUE(capabilities('cairo'))} then R was compiled with support for the 'cairo' devices .
\item R's 'quartz' devices (since R 4.3.0) e.g. \code{\link[grDevices:quartz]{grDevices::quartz()}}, \code{grDevices::png(type = 'quartz')}, etc. If \code{isTRUE(capabilities('aqua'))} then R was compiled with support for the 'quartz' devices (generally only \code{TRUE} on macOS systems).
\item \code{ragg}'s devices (since v1.3.0) e.g. \code{\link[ragg:agg_png]{ragg::agg_png()}}, \code{\link[ragg:agg_capture]{ragg::agg_capture()}}, etc.
}
}
\examples{
if (require("grid") &&
    getRversion() >= "4.2.0" &&
    isTRUE(dev.capabilities()$transformations)) {
  # Only works if active graphics device supports affine transformations
  # such as `png(type="cairo")` on R 4.2+
  grid.newpage()
  gp_text <- gpar(fontsize = 72)
  grid.isocube(top = textGrob("top", gp = gp_text), 
               right = textGrob("right", gp = gp_text),
               left = textGrob("left", gp = gp_text))
}
if (require("grid") &&
    getRversion() >= "4.2.0" &&
    isTRUE(dev.capabilities()$transformations)) {
    colors <- c("#D55E00", "#009E73", "#56B4E9")
    spacings <- c(0.25, 0.2, 0.25)
    texts <- c("pkgname", "left\nface", "right\nface")
    rots <- c(45, 0, 0)
    fontsizes <- c(52, 80, 80)
    sides <- c("top", "left", "right")
    types <- gridpattern::names_polygon_tiling[c(5, 7, 9)]
    l_grobs <- list()
    grid.newpage()
    for (i in 1:3) {
        if (requireNamespace("gridpattern", quietly = TRUE)) {
            bg <- gridpattern::grid.pattern_polygon_tiling(
                       colour = "grey80",
                       fill = c(colors[i], "white"),
                       type = types[i],
                       spacing = spacings[i],
                       draw = FALSE)
        } else {
            bg <- rectGrob(gp = gpar(col = NA, fill = colors[i]))
        }
        text <- textGrob(texts[i], rot = rots[i],
                         gp = gpar(fontsize = fontsizes[i]))
        l_grobs[[sides[i]]] <- grobTree(bg, text)
    }
  grid.newpage()
  grid.isocube(top = l_grobs$top, 
               right = l_grobs$right,
               left = l_grobs$left)
}
\donttest{# May take more than 5 seconds on CRAN machines
if (require("aRtsy") &&
    require("grid") &&
    require("ggplot2") &&
    requireNamespace("gtable", quietly = TRUE) &&
    getRversion() >= "4.2.0" &&
    isTRUE(dev.capabilities()$transformations)
    ) {
  gg <- canvas_planet(colorPalette("lava"), threshold = 3) +
    scale_x_continuous(expand=c(0, 0)) +
    scale_y_continuous(expand=c(0, 0))
grob <- ggplotGrob(gg)
grob <- gtable::gtable_filter(grob, "panel") # grab just the panel
grid.newpage()
grid.isocube(top = grob, left = grob, right = grob,
             gp_border = grid::gpar(col = "darkorange", lwd = 12))

}
}
}
