% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trigonometry.r
\name{inverse-trigonometric-functions}
\alias{inverse-trigonometric-functions}
\alias{arcsine}
\alias{arccosine}
\alias{arctangent}
\alias{arcsecant}
\alias{arccosecant}
\alias{arccotangent}
\title{Angle vector aware inverse trigonometric functions}
\usage{
arcsine(
  x,
  unit = getOption("affiner_angular_unit", "degrees"),
  tolerance = sqrt(.Machine$double.eps)
)

arccosine(
  x,
  unit = getOption("affiner_angular_unit", "degrees"),
  tolerance = sqrt(.Machine$double.eps)
)

arctangent(x, unit = getOption("affiner_angular_unit", "degrees"), y = NULL)

arcsecant(x, unit = getOption("affiner_angular_unit", "degrees"))

arccosecant(x, unit = getOption("affiner_angular_unit", "degrees"))

arccotangent(x, unit = getOption("affiner_angular_unit", "degrees"))
}
\arguments{
\item{x}{A numeric vector}

\item{unit}{A string of the desired angular unit.  Supports the following strings
(note we ignore any punctuation and space characters as well as any trailing \code{s}'s
e.g. "half turns" will be treated as equivalent to "halfturn"):
\itemize{
\item "deg" or "degree"
\item "half-revolution", "half-turn", or "pi-radian"
\item "gon", "grad", "grade", or "gradian"
\item "rad" or "radian"
\item "rev", "revolution", "tr", or "turn"
}}

\item{tolerance}{If \code{x} greater than 1 (or less than -1) but is within a \code{tolerance}
of 1 (or -1) then it will be treated as 1 (or -1)}

\item{y}{A numeric vector or \code{NULL}.
If \code{NULL} (default) we compute the 1-argument arctangent
else we compute the 2-argument arctangent.
For positive coordinates \verb{(x, y)} then \code{arctangent(x = y/x) == arctangent(x = x, y = y)}.}
}
\value{
An \code{\link[=angle]{angle()}} vector
}
\description{
\code{arcsine()}, \code{arccosine()}, \code{arctangent()},
\code{arcsecant()}, \code{arccosecant()}, and \code{arccotangent()} are
inverse trigonometric functions that return \code{\link[=angle]{angle()}} vectors
with a user chosen angular unit.
}
\examples{
arccosine(-1, "degrees")
arcsine(0, "turns")
arctangent(0, "gradians")
arccosecant(-1, "degrees")
arcsecant(1, "degrees")
arccotangent(1, "half-turns")

# `base::atan2(y, x)` computes the angle of the vector from origin to (x, y)
as_angle(as_coord2d(x = 1, y = 1), "degrees")
}
