% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_langmuirLM4.R
\name{mcmc_langmuirLM4}
\alias{mcmc_langmuirLM4}
\title{MCMC Analysis for Langmuir Isotherm Linear (Form 4) Model}
\arguments{
\item{Ce}{Numeric vector of equilibrium concentrations.}

\item{Qe}{Numeric vector of adsorbed amounts.}

\item{burnin}{Integer specifying the number of burn-in iterations (default is 1000).}

\item{mcmc}{Integer specifying the total number of MCMC iterations (default is 5000).}

\item{thin}{Integer specifying the thinning interval (default is 10).}

\item{verbose}{Integer controlling the frequency of progress updates (default is 100).}

\item{plot}{Logical; if TRUE, trace and density plots of the MCMC chains are shown (default is FALSE).}

\item{n_chains}{Number of independent MCMC chains (default = 2).}

\item{seed}{Optional integer for reproducibility.}
}
\value{
A list with:
\describe{
  \item{mcmc_results}{Combined posterior samples (mcmc.list).}
  \item{Qmax_mean}{Posterior mean of Qmax.}
  \item{b_mean}{Posterior mean of b.}
  \item{intercept_mean}{Posterior mean of intercept (b * Qmax).}
  \item{intercept_sd}{Posterior standard deviation of intercept.}
  \item{intercept_ci}{95\% credible interval for intercept.}
  \item{slope_mean}{Posterior mean of slope (-b).}
  \item{slope_sd}{Posterior standard deviation of slope.}
  \item{slope_ci}{95\% credible interval for slope.}
  \item{gelman_diag}{Gelman-Rubin convergence diagnostics.}
  \item{mcmc_summary}{Summary of the first MCMC chain.}
}
}
\description{
Performs Bayesian parameter estimation using Markov Chain Monte Carlo (MCMC) to estimate the parameters of the Langmuir isotherm using its fourth linear form:
Qe / Ce = b * Qmax - b * Qe
This method provides a probabilistic interpretation of the model parameters and accounts for their uncertainties.
It supports multiple MCMC chains and computes convergence diagnostics (Gelman-Rubin).
}
\examples{
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
Qe <- c(0.03409, 0.06025, 0.10622, 0.12842, 0.15299, 0.15379, 0.15735, 0.15735, 0.16607)
mcmc_langmuirLM4(Ce, Qe, burnin = 1000, mcmc = 10000, thin = 10,
                 verbose = 100, plot = TRUE, n_chains = 2, seed = 123)
}
\references{
Gilks, W. R., Richardson, S., & Spiegelhalter, D. J. (1995). \emph{Markov Chain Monte Carlo in Practice}. Chapman and Hall/CRC.
}
\author{
Paul Angelo C. Manlapaz
}
