% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log.R
\name{loginfo}
\alias{loginfo}
\title{Print the full log output of an admixr wrapper to the console.}
\usage{
loginfo(x, target = NA, save = FALSE, prefix = NA, dir = ".", suffix = ".txt")
}
\arguments{
\item{x}{Output from one of the admixr wrappers (d, f4, qpAdm, ...)}

\item{target}{A specific log to examine (relevant for multiple target qpAdm runs)}

\item{save}{Save the log output to a disk?}

\item{prefix}{Prefix of the output log file(s) (name of the admixr command by default)}

\item{dir}{In which directory to save the log file(s)?}

\item{suffix}{Suffix of the output log file(s) (".txt" by default)}
}
\description{
Print the full log output of an admixr wrapper to the console.
}
\examples{
\dontrun{# download an example genomic data set and prepare it for analysis
snps <- eigenstrat(download_data(dirname = tempdir()))

# define a set of populations to analyze and calculate a D statistic
pops <- c("French", "Sardinian", "Han", "Papuan", "Khomani_San", "Mbuti", "Dinka")
result_d <- d(
    W = pops, X = "Yoruba", Y = "Vindija", Z = "Chimp",
    data = snps
)

# examine the full log output associated with the returned object
loginfo(result_d)
}

}
