% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duplicates.R
\name{signal_duplicate_records}
\alias{signal_duplicate_records}
\title{Signal Duplicate Records}
\usage{
signal_duplicate_records(
  dataset,
  by_vars,
  msg = paste("Dataset contains duplicate records", "with respect to",
    "{.var {replace_values_by_names(by_vars)}}"),
  cnd_type = "error",
  class = NULL
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{by_vars} argument are expected to be in the dataset.

\describe{
\item{Default value}{none}
}}

\item{by_vars}{Grouping variables

Defines groups of records in which to look for duplicates.

\describe{
\item{Permitted values}{list of variables created by \code{exprs()}, e.g., \code{exprs(USUBJID, VISIT)}}
\item{Default value}{none}
}}

\item{msg}{The condition message

\describe{
\item{Default value}{\code{paste("Dataset contains duplicate records", "with respect to",
  "{.var {replace_values_by_names(by_vars)}}")}}
}}

\item{cnd_type}{Type of condition to signal when detecting duplicate records.

\describe{
\item{Permitted values}{\code{"message"}, \code{"warning"}, or \code{"error"}}
\item{Default value}{\code{"error"}}
}}

\item{class}{Class of the condition

The specified classes are added to the classes of the condition.
\code{c("duplicate_records", "assert-admiral")} is always added.

\describe{
\item{Default value}{\code{NULL}}
}}
}
\value{
No return value, called for side effects
}
\description{
Signal Duplicate Records
}
\examples{
data(admiral_adsl)

# Duplicate the first record
adsl <- rbind(admiral_adsl[1L, ], admiral_adsl)

signal_duplicate_records(adsl, exprs(USUBJID), cnd_type = "message")
}
\seealso{
Other internal: 
\code{\link{admiral-package}},
\code{\link{extract_duplicate_records}()},
\code{\link{format.basket_select}()}
}
\concept{internal}
\keyword{internal}
