% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorial_plan.R
\name{fp_scaled_axis}
\alias{fp_scaled_axis}
\title{Create a secondary GGPlot2 axis with scaled units and factor names}
\usage{
fp_scaled_axis(fp, fct)
}
\arguments{
\item{fp}{The factorial plan object}

\item{fct}{The standard name of the factor as a string (e.g. \code{"A"}, or \code{"B"}, etc.)}
}
\value{
A \code{ggplot2::sec_axis} object
}
\description{
This is useful when creating contour plots for the FP response surface or
factors interaction plots. It allows to add secondary axes that use the
scaled factor units rather than the coded units (in range -1, 1).
}
\examples{
library(tidyverse)
fp <- fp_design_matrix(2, rep=3) \%>\%
  fp_add_names(A="Temperature (°C)", B="Pressure (bar)") \%>\%
  fp_add_scale(A=c(20,30), B=c(2, 3))
fp$Y <- ccd_experiment_yield$base
fp.lm <- lm(Y~A*B, data=fp)

# Interaction plot:
fp \%>\%
  mutate(
    pred = predict(fp.lm),
    B=factor(B)
  ) \%>\%
  ggplot(aes(x=A, y=pred, color=B)) +
  geom_line() +
  scale_x_continuous(sec.axis = fp_scaled_axis(fp, "A"))+
  scale_color_discrete(labels = fp_scale(fp, "B")) +
  labs(color=fp_name(fp, "B"), y="Yield")

expand.grid(
  A = seq(-1, 1, length.out=100),
  B = seq(-1, 1, length.out=100)
) \%>\% {
  mutate(., Y=predict(fp.lm, newdata=.))
} \%>\%
  ggplot(aes(x=A, y=B, z=Y)) +
  geom_contour_filled() +
  scale_x_continuous(sec.axis = fp_scaled_axis(fp, "A")) +
  scale_y_continuous(sec.axis = fp_scaled_axis(fp, "B")) +
  labs(fill="Yield")
}
\seealso{
\code{\link[=fp_name]{fp_name()}} \code{\link[=fp_scale]{fp_scale()}}
}
