% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{project3}
\alias{project3}
\title{Project Multiple MPMs With or Without Density Dependence}
\usage{
project3(
  mpms = NULL,
  vrms = NULL,
  stageframes = NULL,
  supplements = NULL,
  equivalence = NULL,
  starts = NULL,
  years = NULL,
  patches = NULL,
  tweights = NULL,
  format = NULL,
  entry_time = NULL,
  sp_density = NULL,
  ind_terms = NULL,
  dev_terms = NULL,
  fb_sparse = NULL,
  firstage = NULL,
  finalage = NULL,
  fecage_min = NULL,
  fecage_max = NULL,
  cont = NULL,
  fecmod = NULL,
  density = NULL,
  density_vr = NULL,
  err_check = NULL,
  stochastic = FALSE,
  integeronly = FALSE,
  substoch = 0L,
  nreps = 1L,
  times = 10000L,
  prep_mats = 20L,
  force_fb = FALSE,
  exp_tol = 700,
  theta_tol = 1e+08
)
}
\arguments{
\item{mpms}{An optional list of MPMs. Each MPM must be of class
\code{lefkoMat}.}

\item{vrms}{An optional list of \code{vrm_input} objects, each corresponding
to a distinct MPM that will be created during projection. Each
\code{vrm_input} object requires its own stageframe, entered in the same
order via argument \code{stageframes}.}

\item{stageframes}{An optional list of stageframes, corresponding in number
and order to the MPMs in argument \code{vrms}. Each stageframe must be of
class \code{stageframe}.}

\item{supplements}{An optional list of data frames of class \code{lefkoSD}
that provide supplemental data that should be incorporated into
function-based MPMs. If used, then should be the same number of data frames
as the number of MPMs provided in the list for argument \code{vrms}. MPMs
that do not need supplemental data should be entered as \code{NULL} in this
list. See \code{\link[lefko3]{supplemental}()} for details.}

\item{equivalence}{An optional numeric vector, list of numeric vectors,
data frame of class \code{adaptEq}, or list of data frames of class
\code{adaptEq}. If a numeric vector, then must have the same number of
elements as the number of MPMs, with each element giving the effect of an
individual of each MPM relative to a reference individual. If a list of
vectors, then the list should be composed of as many numeric vectors as
MPMs, with each vector giving the effect of each individual in each stage
relative to a reference individual. Data frames of class \code{adaptEq}, and
lists of such data frames, can be made with function
\code{\link{equiv_input}()}. Numeric entries used in these vectors can be
thought of as Lotka-Volterra interaction terms, such as are used in multiple
species competition models.}

\item{starts}{An optional list of \code{lefkoSV} objects, which are data
frames providing the starting numbers of individuals of each stage. If
provided, then one is needed per MPM. If not provided, then all projections
start with a single individual of each stage per MPM.}

\item{years}{An optional term corresponding either to a single integer vector
of time \code{t} values, if all MPMs will use the same time \code{t} or set
of time \code{t}'s, or a list of such vectors with each vector corresponding
to each MPM in order. In the latter case, a vector composed of a single
\code{NA} value is interpreted to mean that all time \code{t} values in the
MPM should be utilized. If a vector shorter than \code{times} is supplied,
then this vector will be cycled.}

\item{patches}{An optional string vector with length equal to the number of
MPMs, detailing the name of each patch to project for each MPM, in order.
Only a single pop-patch may be projected for each MPM given. A value of
\code{NA} can be supplied to indicate that the population-level matrices
should be projected (if argument \code{mpms} is used and a population-level
set of matrices exist), or that the first patch noted should be used.
Defaults to the population-level set or the first patch, depending on
whether the former exists.}

\item{tweights}{An optional list composed of numeric vectors or matrices
denoting the probabilities of choosing each matrix in each MPM in a
stochastic projection. If an element of the list is a matrix, then a
first-order Markovian environment is assumed, in which the probability of
choosing a specific annual matrix depends on which annual matrix is
currently chosen. If an element of the list is a vector, then the choice of
annual matrix is assumed to be independent of the current matrix. Defaults
to equal weighting among matrices. If used, then one element per MPM is
required, with equal weighting assumed for any element set to \code{NULL}.}

\item{format}{An optional integer vector indicating the kind of
function-based MPM to create for each \code{vrm_input} object entered in
argument \code{vrms}. Possible choices include: \code{1}, Ehrlen-format
historical MPM; \code{2}, deVries-format historical MPM; \code{3},
ahistorical MPM (default); \code{4}, age-by-stage MPM; and \code{5}, Leslie
(age-based) MPM.}

\item{entry_time}{An optional integer vector giving the entry time for each
MPM into the projection. Defaults to a zero vector with the length of the
number of MPMs, as given either by argument \code{mpms} or \code{vrms}.}

\item{sp_density}{An optional argument for use with \code{vrm_input} objects
that specifies the spatial density to be used in each time step. If used,
may either be a numeric vector giving a single spatial density for each
\code{vrm_input} object entered in argument \code{vrms} (in this case, the
value of spatial density given for each \code{vrm_input} object will be held
constant through the projection), or a list of as many numeric vectors as
\code{vrm_input} objects, with the length of each vector giving the spatial
density at each time step. If vectors are shorter than specified in 
\code{times}, then these values will be cycled.}

\item{ind_terms}{An optional argument providing values of individual or
environmental covariate values for \code{vrm_input} objects used in
function-based projection. Can be set either to a single data frame with 3
columns giving values for up to 3 covariates across time (rows give the time
order of these values), or a list of as many such data frames as
\code{vrm_input} objects. In the latter case, \code{vrm_input} objects that
do not use such covariates should have the associated element set to
\code{NULL}. Unused terms within each data frame must be set to \code{0}
(use of \code{NA} will produce errors.) If the number of rows is less than
\code{times}, then these values will be cycled.}

\item{dev_terms}{An optional list of data frames, one for each
\code{vrm_input} object. Each should include 14 columns and up to
\code{times} rows showing the values of the deviation terms to be added to
each linear vital rate. The column order should be: 1: survival,
2: observation, 3: primary size, 4: secondary size, 5: tertiary size,
6: reproduction, 7: fecundity, 8: juvenile survival,
9: juvenile observation, 10: juvenile primary size, 11: juvenile secondary
size, 12: juvenile tertiary size, 13: juvenile reproduction, and
14: juvenile maturity transition. Unused terms must be set to \code{0} (use
of \code{NA} will produce errors). Single or small numbers of values per
vital rate model are also allowed, and if the number of rows is less than
\code{times}, then the terms will be cycled.}

\item{fb_sparse}{A logical vector indicating whether function-based MPMs
should be produced in sparse matrix format. Defaults to \code{FALSE} for
each MPM.}

\item{firstage}{An optional integer vector used for function-based Leslie
and age-by-stage MPMs giving the starting ages in such MPMs. Use only if at
least one MPM is both function-based and has age structure. Typically,
the starting age in such MPMs should be set to \code{0} if post-breeding and
\code{1} if pre-breeding. All other MPMs should be set to \code{0}. Do not
use if no MPM has age structure.}

\item{finalage}{An optional integer vector used for function-based Leslie
and age-by-stage MPMs giving the final ages in such MPMs. Use only if at
least one MPM is both function-based and has age structure. Do not use if no
MPM has age structure.}

\item{fecage_min}{An optional integer vector used for function-based Leslie
MPMs giving the first age at which organisms can be reproductive in such
MPMs. Use only if at least one MPM is a function-based Leslie MPM. Defaults
to the values given in \code{firstage}.}

\item{fecage_max}{An optional integer vector used for function-based Leslie
MPMs giving the final age at which organisms can be reproductive in such
MPMs. Use only if at least one MPM is a function-based Leslie MPM. Defaults
to the values given in \code{finalage}.}

\item{cont}{An optional vector used for function-based Leslie and
age-by-stage MPMs stating whether the MPM should should include a stasis
transition within the final age. This should be used only when an organism
can maintain the demographic characteristics of the final described age
after reaching that age. Can be entered as a logical vector or an integer
vector. MPMs without age structure should be entered as \code{0} or
\code{FALSE}. Do not use if no MPM has age structure.}

\item{fecmod}{An optional vector used for function-based MPMs giving scalar
multipliers for fecundity terms, when two fecundity variables are used for a
collective fecundity per individual. Each entry refers to each 
\code{vrm_input} object in argument \code{vrms}, in the same order.}

\item{density}{An optional list of data frames of class \code{lefkoDens},
which provide details for density dependence in MPM elements and have been
created with function \code{\link[lefko3]{density_input}()}. If used, then
one such data frame per MPM is required. MPMs to be run without density
dependence should be set to \code{NULL}.}

\item{density_vr}{An optional list of data frames of class
\code{lefkoDensVR}, which provide details for density dependence in vital
rate models and have been created with function
\code{link[lefko3]{density_vr}()}. If used, then one such data frame per MPM
is required. MPMs to be run without vital describing density dependence
relationships in vital rates should be set to \code{NULL}. Can only be used
with function-based projections.}

\item{err_check}{A logical value indicating whether to include an extra list
of output objects for error checking. Can also be set to the text value
\code{"extreme"}, in which case all \code{err_check} output plus a multiple
level list with each MPM used in each time step will be output.}

\item{stochastic}{A logical value indicating whether the projection will be
run as a temporally stochastic projection. Defaults to \code{FALSE}.}

\item{integeronly}{A logical value indicating whether to round the number of
individuals projected in each stage at each occasion in each MPM to the
nearest integer. Defaults to \code{FALSE}.}

\item{substoch}{An integer value indicating whether to force survival-
transition matrices to be substochastic in density dependent and density
independent simulations. Defaults to \code{0}, which does not enforce
substochasticity. Alternatively, \code{1} forces all survival-transition
elements to range from 0.0 to 1.0, and forces fecundity to be non-negative;
and \code{2} forces all column rows in the survival-transition matrices to
total no more than 1.0, in addition to the actions outlined for option
\code{1}. Both settings \code{1} and \code{2} change negative fecundity
elements to \code{0.0}.}

\item{nreps}{The number of replicate projections. Defaults to \code{1}.}

\item{times}{Number of occasions to iterate per replicate. Defaults to
\code{10000}.}

\item{prep_mats}{An integer value for use when creating function-based MPM
projections. If using \code{vrms} input instead of \code{mpms} input, then
this argument determines how many matrices should be used as a limit to
develop matrices prior to running the projection. See \code{Notes} for
further details.}

\item{force_fb}{A logical value indicating whether to force function-based
MPMs to be developed at each time step even if fewer than \code{prep_mats}.
Defaults to \code{FALSE}.}

\item{exp_tol}{A numeric value used to indicate a maximum value to set
exponents to in the core kernel to prevent numerical overflow. Defaults to
\code{700}.}

\item{theta_tol}{A numeric value used to indicate a maximum value to theta as
used in the negative binomial probability density kernel. Defaults to
\code{100000000}, but can be reset to other values during error checking.}
}
\value{
A list of class \code{adaptProj}, with the following elements:
\item{comm_out}{A two-level list with the top level list having number of
elements equal to the number of MPMs used as input, and the lower level
corresponding to the number of replicates. Each element of the lower level
list is a data frame showing the number of individuals in each stage at each
time. Rows and columns in the data frames correspond to stages and time
steps, respectively.}
\item{N_out}{A list with the number of elements equal to the number of
replicates. Each element within this list is data frame showing the number
of individuals of each species or genotype alive at each time. The number of
rows are equal to the number of MPMs used, and the columns correspond to the
time steps.}
\item{stageframe_list}{A list in which each element is the stageframe for
each MPM used.}
\item{hstages_list}{A list giving the used \code{hstages} data frames, which
identify the correct stage pairing for each row / column in each
historical MPM utilized.}
\item{agestages_list}{A list giving the used \code{agestages} data frames,
which identify the correct age-stage pairing for each row / column in each
age-by-stage MPM utilized.}
\item{labels}{A small data frame giving the the population and patch
identities for each MPM entered.}
\item{err_check}{An optional list composed of an additional six lists, each
of which has the number of elements equal to the number of MPMs utilized.
List output include \code{allstages_all}, which gives the indices of
estimatedtransitions in MPMs constructed by function \code{project3()} from
input vital rate models; \code{allmodels_all}, which provides all vital rate
models as decomposed and interpreted by function \code{project3()};
\code{equivalence_list}, which gives the stage equivalence for density
calculations across MPMs; \code{density_list}, which gives the
\code{density} inputs utilized; \code{dens_index_list}, which provides
indices used to identify matrix elements for density dependence; and
\code{density_vr_list}, which gives the \code{density_vr} inputs utilized.}
}
\description{
Function \code{project3} uses pre-existing or function-based MPMs to run
community projection simulations, in which different populations are run as
separate MPMs. Density dependence can be used with individual equivalence
vectors specifying Lotka-Volterra coefficients to adjust overall population
sizes to make them comparable.
}
\section{Notes}{


This function has been optimized in the function-based approach such that
if there are relatively few matrices required per MPM to run the projection
forward, then these matrices will be made prior to running the projection.
This approach saves time, but only if there are relatively few unique
matrices required for each MPM. If many or only unique MPMs are required at
each time step, then the matrices will be made on the fly during the
projection itself. Such a situation will most likely occur if each time
step requires a new matrix resulting from a unique individual covariate
value, or if the \code{density_vr} argument is used. The key argument
determining this behavior is \code{prep_mats}, which provides the maximum
limit for the number of matrices required per MPM in order to create
matrices prior to projection.
}

\examples{
library(lefko3)
data(cypdata)

data(cypa_data)

sizevector <- c(0, 0, 0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
stagevector <- c("SD", "P1", "P2", "P3", "SL", "D", "XSm", "Sm", "Md", "Lg",
  "XLg")
repvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
obsvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
immvector <- c(0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 0, 0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)

cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  propstatus = propvector, immstatus = immvector, indataset = indataset,
  binhalfwidth = binvec)

cycaraw_v1 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004,
  patchidcol = "patch", individcol = "plantid", blocksize = 4,
  sizeacol = "Inf2.04", sizebcol = "Inf.04", sizeccol = "Veg.04",
  repstracol = "Inf.04", repstrbcol = "Inf2.04", fecacol = "Pod.04",
  stageassign = cypframe_raw, stagesize = "sizeadded", NAas0 = TRUE,
  NRasRep = TRUE)
  
cyparaw_v1 <- verticalize3(data = cypa_data, noyears = 18, firstyear = 1994,
  individcol = "plant_id", blocksize = 2, sizeacol = "Inf.94",
  sizebcol = "Veg.94", repstracol = "Inf.94", fecacol = "Inf.94",
  stageassign = cypframe_raw, stagesize = "sizeadded", NAas0 = TRUE,
  NRasRep = TRUE)

cypsupp2r <- supplemental(stage3 = c("SD", "P1", "P2", "P3", "SL", "D", 
    "XSm", "Sm", "SD", "P1"),
  stage2 = c("SD", "SD", "P1", "P2", "P3", "SL", "SL", "SL", "rep",
    "rep"),
  eststage3 = c(NA, NA, NA, NA, NA, "D", "XSm", "Sm", NA, NA),
  eststage2 = c(NA, NA, NA, NA, NA, "XSm", "XSm", "XSm", NA, NA),
  givenrate = c(0.10, 0.20, 0.20, 0.20, 0.25, NA, NA, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, NA, NA, NA, NA, 0.5, 0.5),
  type =c(1, 1, 1, 1, 1, 1, 1, 1, 3, 3),
  stageframe = cypframe_raw, historical = FALSE)
cyp_supp_list1 <- list(cypsupp2r, cypsupp2r)

cycamatrix2r <- rlefko2(data = cycaraw_v1, stageframe = cypframe_raw, 
  year = "all", patch = "all", stages = c("stage3", "stage2", "stage1"),
  size = c("size3added", "size2added"), supplement = cypsupp2r,
  yearcol = "year2", patchcol = "patchid", indivcol = "individ")

cypamatrix2r <- rlefko2(data = cyparaw_v1, stageframe = cypframe_raw, 
  year = "all", stages = c("stage3", "stage2", "stage1"),
  size = c("size3added", "size2added"), supplement = cypsupp2r,
  yearcol = "year2", patchcol = "patchid", indivcol = "individ")

cyp_mpm_list <- list(cycamatrix2r, cypamatrix2r)

cyca2_start <- start_input(cycamatrix2r, stage2 = c("SD", "P1", "P2"),
  value = c(500, 100, 200))
cypa2_start <- start_input(cypamatrix2r, stage2 = c("SD", "P1", "P2"),
  value = c(5000, 1000, 2000))
cyp_start_list <- list(cyca2_start, cypa2_start)

cyp2_dv <- density_input(cypamatrix2r, stage3 = c("SD", "P1"),
  stage2 = c("rep", "rep"), style = c(1, 1), alpha = c(0.5, 1.2),
  beta = c(1.0, 2.0), type = c(2, 1))
cyp_dv_list <- list(cyp2_dv, cyp2_dv)

cyp_comm_proj <- project3(mpms = cyp_mpm_list, starts = cyp_start_list,
  density = cyp_dv_list, times = 10)
  
summary(cyp_comm_proj)

}
