% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_planet.R
\name{canvas_planet}
\alias{canvas_planet}
\title{Draw Planets}
\usage{
canvas_planet(
  colors,
  threshold = 4,
  iterations = 200,
  starprob = 0.01,
  fade = 0.2,
  radius = NULL,
  center.x = NULL,
  center.y = NULL,
  light.right = TRUE,
  resolution = 1500
)
}
\arguments{
\item{colors}{a character specifying the colors used for a single planet. Can also be a list where each entry is a vector of colors for a planet.}

\item{threshold}{a character specifying the threshold for a color take.}

\item{iterations}{a positive integer specifying the number of iterations of the algorithm.}

\item{starprob}{a value specifying the probability of drawing a star in outer space.}

\item{fade}{a value specifying the amount of fading to apply.}

\item{radius}{a numeric (vector) specifying the radius of the planet(s).}

\item{center.x}{the x-axis coordinate(s) for the center(s) of the planet(s).}

\item{center.y}{the y-axis coordinate(s) for the center(s) of the planet(s).}

\item{light.right}{whether to draw the light from the right or the left.}

\item{resolution}{resolution of the artwork in pixels per row/column. Increasing the resolution increases the quality of the artwork but also increases the computation time exponentially.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function paints one or multiple planets and uses a cellular automata to fill their surfaces.
}
\examples{
\donttest{
set.seed(1)

# Simple example
canvas_planet(colors = colorPalette("lava"), threshold = 3)

# Advanced example
colors <- list(
  c("khaki1", "lightcoral", "lightsalmon"),
  c("dodgerblue", "forestgreen", "white"),
  c("gray", "darkgray", "beige")
)
canvas_planet(colors,
  radius = c(800, 400, 150),
  center.x = c(1, 500, 1100),
  center.y = c(1400, 500, 1000),
  starprob = 0.005
)
}

}
\references{
\url{https://fronkonstin.com/2021/01/02/neighborhoods-experimenting-with-cyclic-cellular-automata/}
}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
