% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KL_div.r
\name{KL_div}
\alias{KL_div}
\title{Computes the Kullback-Leibler divergence based on kernel density estimates}
\usage{
KL_div(x, y, from_a, to_b)
}
\arguments{
\item{x}{numeric, the values from a sample p}

\item{y}{numeric, the values from a sample q}

\item{from_a}{numeric, the lower limit of the integration}

\item{to_b}{numeric, the upper limit of the integration}
}
\value{
a numeric value that is the kl divergence
}
\description{
Computes the Kullback-Leibler divergence based on kernel density estimates
of two samples.
}
\details{
The Kullback-Leibler divergence is defined as
\deqn{D_{KL}(P||Q) = \int_{-\infty}^{\infty} p(x) \log \frac{p(x)}{q(x)} dx}
}
\examples{
set.seed(123)
p <- rnorm(100)
q <- rnorm(100)
KL_div(p, q, -Inf, Inf) # 0.07579204
q <- rnorm(100, 10, 4)
KL_div(p, q, -Inf, Inf) # 7.769912
}
