% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/advanced_search.R
\name{FacetAggregator}
\alias{FacetAggregator}
\title{Facet Aggregator}
\description{
Faceted search aggregator for computing aggregations/counts
}
\examples{
\dontrun{
aggregator <- FacetAggregator$new()
facets <- aggregator$aggregate(
  documents = list(
    list(category = "tech", author = "Alice"),
    list(category = "science", author = "Bob")
  ),
  facet_fields = c("category", "author")
)
}

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FacetAggregator-aggregate}{\code{FacetAggregator$aggregate()}}
\item \href{#method-FacetAggregator-to_list}{\code{FacetAggregator$to_list()}}
\item \href{#method-FacetAggregator-clone}{\code{FacetAggregator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FacetAggregator-aggregate"></a>}}
\if{latex}{\out{\hypertarget{method-FacetAggregator-aggregate}{}}}
\subsection{Method \code{aggregate()}}{
Aggregate facet values from documents
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FacetAggregator$aggregate(documents, facet_configs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{documents}}{List of documents with metadata}

\item{\code{facet_configs}}{List of field names or FacetConfig objects}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Named list mapping field names to FacetResult
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FacetAggregator-to_list"></a>}}
\if{latex}{\out{\hypertarget{method-FacetAggregator-to_list}{}}}
\subsection{Method \code{to_list()}}{
Convert facet results to list format
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FacetAggregator$to_list(facet_results)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{facet_results}}{Named list of FacetResult objects}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List format suitable for JSON
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FacetAggregator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FacetAggregator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FacetAggregator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
