% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnd_TMVT.R
\name{mvrandt}
\alias{mvrandt}
\title{Simulate truncated multivariate normal (TMVT) using the Vecchia approximation}
\usage{
mvrandt(
  lower,
  upper,
  delta,
  df,
  locs = NULL,
  covName = "matern15_isotropic",
  covParms = c(1, 0.1, 0),
  m = 30,
  sigma = NULL,
  N = 1000,
  verbose = FALSE
)
}
\arguments{
\item{lower}{lower bound vector for TMVT}

\item{upper}{upper bound vector for TMVT}

\item{delta}{MVT shifting parameter}

\item{df}{degrees of freedom}

\item{locs}{location (feature) matrix n X d}

\item{covName}{covariance function name from the `GpGp` package}

\item{covParms}{parameters for `covName`}

\item{m}{Vecchia conditioning set size}

\item{sigma}{dense covariance matrix, not needed when `locs` is not null}

\item{N}{number of samples required}

\item{verbose}{verbose level}
}
\value{
n X N matrix of generated samples
}
\description{
Simulate truncated multivariate normal (TMVT) using the Vecchia approximation
}
