# VecDep

This R package gathers together several functions that can be used for copula-based measuring of dependence between a finite amount of random vectors.

In particular, several estimation procedures are implemented for the class of phi-dependence measures, including Gaussian copula and hierarchical Archimedean copula methods, as studied in 

* De Keyser, S. & Gijbels, I. (2024). Parametric dependence between random vectors via copula-based divergence measures. Journal of Multivariate Analysis 203:105336. doi: https://doi.org/10.1016/j.jmva.2024.105336,

and a semi-parametric meta-elliptical method and fully non-parametric methods, as investigated in 

* De Keyser, S. & Gijbels, I. (2024). Hierarchical variable clustering via copula-based divergence measures between random vectors. International Journal of Approximate Reasoning 165:109090. doi: https://doi.org/10.1016/j.ijar.2023.109090.

The latter reference also discusses an algorithm for hierarchical variable clustering based on multivariate similarities between random vectors, which is implemented in this R package as well.
Next to this, functions for Bures-Wasserstein dependence coefficients and Gaussian copula correlation matrix penalization techniques, as discussed in 

* De Keyser, S. & Gijbels, I. (2024). High-dimensional copula-based Wasserstein dependence. doi: https://doi.org/10.48550/arXiv.2404.07141,

are implemented as well. 

