% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joint_surv_VA.R
\name{joint_ms_format}
\alias{joint_ms_format}
\title{Formats the Parameter Vector}
\usage{
joint_ms_format(object, par = object$start_val)
}
\arguments{
\item{object}{a joint_ms object from \code{\link{joint_ms_ptr}}.}

\item{par}{parameter vector to be formatted.}
}
\value{
A list with the following elements:
\item{markers}{list with an element for each marker. The lists contains an
element called \code{fixef} for non-time-varying fixed effects and an
element called \code{fixef_vary} time-varying fixed effects.}
\item{survival}{list with an element for each survival outcome. The lists
contains an element called \code{fixef} for non-time-varying fixed effects,
an element called \code{fixef_vary} time-varying fixed effects, and an
element called \code{associations} for the association parameters.}
\item{vcov}{contains three covariance matrices called \code{vcov_marker},
\code{vcov_vary} and \code{vcov_surv} for the covariance matrix of the
markers error term, the time-varying random effects, and the frailties,
respectively.}
}
\description{
Formats a parameter vector by putting the model parameters into a \code{list}
with elements for each type of parameter.
}
\examples{
# load in the data
library(survival)
data(pbc, package = "survival")

# re-scale by year
pbcseq <- transform(pbcseq, day_use = day / 365.25)
pbc <- transform(pbc, time_use = time / 365.25)

# create the marker terms
m1 <- marker_term(
  log(bili) ~ 1, id = id, data = pbcseq,
  time_fixef = bs_term(day_use, df = 5L),
  time_rng = poly_term(day_use, degree = 1L, raw = TRUE, intercept = TRUE))
m2 <- marker_term(
  albumin ~ 1, id = id, data = pbcseq,
  time_fixef = bs_term(day_use, df = 5L),
  time_rng = poly_term(day_use, degree = 1L, raw = TRUE, intercept = TRUE))

# base knots on observed event times
bs_term_knots <-
  with(pbc, quantile(time_use[status == 2], probs = seq(0, 1, by = .2)))

boundary <- c(bs_term_knots[ c(1, length(bs_term_knots))])
interior <- c(bs_term_knots[-c(1, length(bs_term_knots))])

# create the survival term
s_term <- surv_term(
  Surv(time_use, status == 2) ~ 1, id = id, data = pbc,
  time_fixef = bs_term(time_use, Boundary.knots = boundary, knots = interior))

# create the C++ object to do the fitting
model_ptr <- joint_ms_ptr(
  markers = list(m1, m2), survival_terms = s_term,
  max_threads = 2L, ders = list(0L, c(0L, -1L)))

# find the starting values
start_vals <- joint_ms_start_val(model_ptr)

# format the starting values
joint_ms_format(model_ptr,start_vals)
}
