% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot_Barras.R
\name{Plot.Barras}
\alias{Plot.Barras}
\title{Cree un gráfico de barras que muestre la información de forma horizontal o
vertical, para variables nominales u ordinales con dos diferentes paquetes}
\usage{
Plot.Barras(
  datos,
  valores,
  categoria,
  ano,
  periodo,
  freqRelativa = FALSE,
  ylim,
  vertical = TRUE,
  ordinal = FALSE,
  colores,
  titulo = "",
  labelX = "",
  labelY = "Número de",
  labelEje,
  addPeriodo = FALSE,
  textInfo = labelY,
  libreria = c("highcharter", "plotly"),
  estilo = NULL,
  estatico = FALSE
)
}
\arguments{
\item{datos}{Un data frame, no un vector numérico.}

\item{valores}{Variable numérica que contiene los valores que desea graficar.}

\item{categoria}{Una variable categórica dentro del data frame ingresado en \code{datos}.}

\item{ano}{Argument deprecated. This Argument still exist but will be removed
in the next version.}

\item{periodo}{Argument deprecated. This Argument still exist but will be removed
in the next version.}

\item{freqRelativa}{Si es \code{FALSE} (\emph{valor predeterminado}) la serie graficada
representará las frecuencias absolutas (\emph{conteo}) más no las relativas (\emph{porcentaje}).}

\item{ylim}{Vector numérico que especifica el límite inferior y superior,
respectivamente, del eje \code{Y}. Si no se introduce algún valor se mostrará
todo el rango disponible para dicho eje.}

\item{vertical}{Si es \code{TRUE} (\emph{valor predeterminado}) indicará que la orientación
del gráfico será vertical.}

\item{ordinal}{Si es \code{TRUE} indicará que las categorías de la variable ingresada
son ordinales (\emph{no nominales}), esto con el fin de ordenar la disposición en
el que se presentan en el eje del gráfico, el valor por defecto es \code{FALSE}.}

\item{colores}{Cadena de caracteres indicando los colores con los cuales se
deben colorear cada una de las series correspondiente a cada nivel del
argumento \code{categoria}. Si no se introduce algún vector se usará la paleta
\code{rainbow} por defecto.}

\item{titulo}{Cadena de caracteres indicando el título principal del plot.}

\item{labelX}{Cadena de caracteres indicando la etiqueta del eje \code{X}. Por
defecto se emplea el rótulo "Periodo".}

\item{labelY}{Cadena de caracteres indicando la etiqueta del eje \code{Y}.}

\item{labelEje}{Cadena de caracteres indicando la etiqueta del eje \code{X} o \code{Y}
(\emph{dependiendo de la orientación del gráfico}). Por defecto se emplea el rótulo
\code{"Número de "}.}

\item{addPeriodo}{Argument deprecated. This Argument still exist but will be
removed in the next version.}

\item{textInfo}{Cadena de caracteres que especifica el texto que se escribe
dentro de la caja de información al posar el cursor en alguna barra en el
gráfico, producido por \code{Highcharter}, el valor por defecto es igual al de
\code{labelX}.}

\item{libreria}{Cadena de caracteres que indica el paquete con el cual se realizará
el plot. Los valores permitidos son \code{"highcharter"} (\emph{valor predeterminado})
y \code{"plotly"}. Los valores se emparejarán parcialmente.}

\item{estilo}{Lista compuesta por varios parámetros, los cuales van a ser usados
de acuerdo con la librería especificada para graficar el plot y cuyo objetivo
es personalizar pequeños detalles de ésta.
\itemize{
\item \code{hc.Tema}, \code{hc.Credits}, \code{ply.Credits}, \code{gg.Tema} y \code{gg.Texto}: Igual uso
que en \code{\link[=Plot.Series]{Plot.Series()}}
\item \code{ply.Legend}: Por defecto la gráfica muestra la leyenda fuera del gráfico
de pie, si se introduce la cadena de texto \code{"inside"} se resumirá toda la
información dentro del pie.
\item \code{gg.Bar}: Una lista de parámetros admitidos por la función \link[ggplot2:geom_bar]{geom_bar()}).
}}

\item{estatico}{Si es \code{FALSE} (\emph{valor predeterminado}) el gráfico a retornar
será dinámico (\emph{dependiendo de la librería seleccionada}), en caso contrario
se retornará un gráfico estático construido con \code{ggplot2}.}
}
\value{
Retorna el diagrama de barras (\emph{objeto widget de HTML}) creado. La clase del
objeto retornado será un "htmlwidget" y dependiendo de la librería usada
pertenecerá adicionalmente a la clase "highchart" o "plotly".
}
\description{
Esta función permite mostrar de forma interactiva (\emph{y estática}) un gráfico
de barras verticales u horizontales cuya altura/longitud es proporcional al
valor de la variable (\emph{categorías de una variable cualitativa}), lo anterior
para ayudar a la creación de informes descriptivos y analíticos. Dicho diagrama
se puede representar usando dos diferentes librerías que son \code{Highcharter} y
\code{Plotly}, las cuales usan internamente \code{JavaScript}.
}
\details{
Al usar el paquete \code{Highcharter} y usar las opciones de descarga, el nombre
del archivo descargado será la concatenación del plot graficado y la categoría
usada, así, por ejemplo, si se graficó el diagrama de barras para la categoría
"Nacionalidad" el nombre será \code{PlotBarras_Nacionalidad.png}.
}
\section{Lista de argumentos de estilo}{


Sabemos que puede ser abrumador el número de argumentos dentro del parámetro
\code{estilo}, pero es necesario si queremos ofrecer al usuario la máxima
personalización dentro de cada función usando cualquier librería. Por tal
razón, a continuación, se detalla el listado completo de argumentos, usados
al especificar la librería y en qué función están presentes
(\emph{marcado con una × si lo posee}).\tabular{clcccccccc}{
   \strong{Librería} \tab \strong{estilo$} \tab \code{\link[=Plot.Series]{Plot.Series()}} \tab \code{\link[=Plot.Barras]{Plot.Barras()}} \tab \code{\link[=Plot.Apiladas]{Plot.Apiladas()}} \tab \code{\link[=Plot.Boxplot]{Plot.Boxplot()}} \tab \code{\link[=Plot.Radar]{Plot.Radar()}} \tab \code{\link[=Plot.Treemap]{Plot.Treemap()}} \tab \code{\link[=Plot.Torta]{Plot.Torta()}} \tab \code{\link[=Plot.Drilldown]{Plot.Drilldown()}} \cr
   — \tab \emph{gg.Tema} \tab × \tab × \tab × \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Texto} \tab × \tab × \tab × \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Legend} \tab × \tab  \tab × \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Linea} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Punto} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Bar} \tab  \tab × \tab × \tab  \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.VarWidth} \tab  \tab  \tab  \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.OutShape} \tab  \tab  \tab  \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.JitWidth} \tab  \tab  \tab  \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.JitSize} \tab  \tab  \tab  \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Range} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   \strong{ggplot2} \tab \emph{gg.plty} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{gg.plwd} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{gg.cglwd} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{gg.cglcol} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{gg.fontsize.title} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.fontsize.labels} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.fontcolor.labels} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.border.lwds} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.border.col} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.lowerbound.cex.labels} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.force.print.labels} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   — \tab \emph{gg.overlap.labels} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   » \tab \emph{hc.Tema} \tab × \tab × \tab × \tab × \tab  \tab × \tab × \tab × \cr
   l \tab \emph{hc.Credits} \tab × \tab × \tab × \tab × \tab  \tab × \tab × \tab × \cr
   \strong{highcharter} \tab \emph{hc.BoxInfo} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   l \tab \emph{hc.Slider} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   » \tab \emph{hc.borderRadius} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   • \tab \emph{ply.Credits} \tab × \tab × \tab × \tab × \tab × \tab × \tab × \tab  \cr
   ° \tab \emph{ply.Legend} \tab  \tab × \tab  \tab  \tab  \tab  \tab × \tab  \cr
   ° \tab \emph{ply.LegendPosition} \tab × \tab  \tab × \tab × \tab × \tab  \tab  \tab  \cr
   \strong{plotly} \tab \emph{ply.Interaction} \tab × \tab  \tab  \tab × \tab  \tab  \tab  \tab  \cr
   ° \tab \emph{ply.Relleno} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   ° \tab \emph{ply.Opacidad} \tab  \tab  \tab  \tab  \tab × \tab × \tab  \tab  \cr
   • \tab \emph{ply.LegendTitle} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   \strong{dygraphs} \tab \emph{dyg.LegendWidth} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   » \tab \emph{dyg.Resaltar} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   — \tab \emph{e.Tema} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{e.Credits} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   \strong{echarts4r} \tab \emph{e.Forma} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{e.LegType} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   — \tab \emph{e.LegLoc} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
}
}

\examples{
\dontshow{if (all(require("tibble"), require("dplyr"))) withAutoprint(\{ # examplesIf}
# Ejemplo generalizado (sin uso de un consolidado como input)
# library("tibble"); library("dplyr")
set.seed(42)
Blood <- tibble(
  Group = sample(c("O", "A", "B", "AB"), size = 200, prob = c(0.5, 0.3, 0.16, 0.4), replace = TRUE),
  RH    = sample(c("+", "-"), size = 200, replace = TRUE),
  Prevalence = round(runif(200)*100)
)
Plot.Barras(
  datos     = Blood     ,
  valores   = Prevalence,
  categoria = Group     ,
  ordinal   = TRUE      ,
  colores   = c("#FF553D", "#A5FF67", "#40D2FF", "#FFDB5C"),
  labelY    = "Prevalence"
)
Plot.Barras(
  datos     = Blood     ,
  valores   = Prevalence,
  categoria = Group     ,
  colores   = c("#FF553D", "#A5FF67", "#40D2FF", "#FFDB5C"),
  labelY    = "Prevalence",
  libreria  = "plotly"
)
\dontshow{\}) # examplesIf}
\dontshow{if (require("dplyr")) withAutoprint(\{ # examplesIf}
# ---------------------------------------------------------------------------
Msj <- "Ac\u00e1 puede ir m\u00e1s informaci\u00f3n acerca del gr\u00e1fico."
Plot.Barras(
  datos        = ejConsolidadoGrad |> filter(YEAR==2021, SEMESTRE==1),
  categoria    = "NIVEL",
  freqRelativa = TRUE,
  vertical     = TRUE,
  ordinal      = TRUE,
  colores      = c("#D7191C", "#FDAE61", "#FFFFBF", "#ABDDA4", "#2B83BA"),
  titulo       = "GRADUADOS DE ACUERDO CON EL NIVEL DE FORMACI\u00d3N (Periodo 2021-1)",
  labelY       = "Frecuencia Relativa<br>(\% de graduados)",
  textInfo     = "Porcentaje de Graduados",
  libreria     = "highcharter",
  estilo       = list(hc.Tema = 2, hc.Credits = Msj)
)
# ---------------------------------------------------------------------------
Txt <- "DISTRIBUCI\u00d3N DEL N\u00daMERO DE GRADUADOS POR NIVEL"
Msj <- "A\u00f1o 2020, sin segregar por semestre (considerando ambos)."
Plot.Barras(
  datos     = ejConsolidadoGrad |> filter(YEAR == 2020),
  categoria = "NIVEL",
  vertical  = FALSE,
  ordinal   = FALSE,
  colores   = c("#66C2A5", "#FC8D62", "#8DA0CB", "#E78AC3", "#A6D854"),
  titulo    = Txt,
  labelY    = "N\u00famero de Graduados",
  libreria  = "plotly",
  estilo    = list(
    ply.Credits = list(x = 0.45, y = 1.1, text = Msj), ply.Legend = FALSE
  )
)
# ---------------------------------------------------------------------------
# Ejemplo usando el caso estático (ggplot2)
Plot.Barras(
  datos     = ejConsolidadoGrad |> filter(YEAR == 2020),
  categoria = "NIVEL",
  vertical  = FALSE,
  ordinal   = FALSE,
  colores   = c("#E41A1C", "#377EB8", "#4DAF4A", "#984EA3", "#FF7F00"),
  titulo    = gsub("DE GR", "DE\nGR", Txt),
  labelY    = "N\u00famero de Graduados",
  estatico  = TRUE,
  estilo    = list(
    gg.Tema  = 10,
    gg.Bar   = list(width = 0.2, color = "#000000"),
    gg.Texto = list(subtitle = gsub("A", "\nA", Msj),
                    caption  = "Informaci\u00f3n Disponible desde 2009-1",
                    tag      = "\u00ae"
    )
  )
)
\dontshow{\}) # examplesIf}
}
