% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_identifier.R
\name{vis_identifier_grp_comparison}
\alias{vis_identifier_grp_comparison}
\title{Visualize Comparison of an Molecule Identifier between Groups}
\usage{
vis_identifier_grp_comparison(
  dataset = NULL,
  id = NULL,
  grp_df,
  samples = NULL,
  fun_type = c("betweenstats", "withinstats"),
  type = c("parametric", "nonparametric", "robust", "bayes"),
  pairwise.comparisons = TRUE,
  p.adjust.method = c("holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr",
    "none"),
  ggtheme = cowplot::theme_cowplot(),
  ...
)
}
\arguments{
\item{dataset}{the dataset to obtain identifiers.}

\item{id}{the molecule identifier.}

\item{grp_df}{When \code{dataset} and \code{id} are all not \code{NULL}, it should be a \code{data.frame} with 2 or 3 columns.
\itemize{
\item The first column refers to sample ID.
\item The second column refers to groups indicated in axis X.
\item The third column is optional, which indicates facet variable.
When any of \code{dataset} and \code{id} is \code{NULL}, it should be a \code{data.frame} with 3 or 4 columns.
\item The first column refers to sample ID.
\item The second column refers to values indicated in axis Y.
\item The third column refers to groups indicated in axis X.
\item The fourth column is optional, which indicates facet variable.
}}

\item{samples}{default is \code{NULL}, can be common sample names for two datasets.}

\item{fun_type}{select the function to compare groups.}

\item{type}{A character specifying the type of statistical approach:
\itemize{
\item \code{"parametric"}
\item \code{"nonparametric"}
\item \code{"robust"}
\item \code{"bayes"}
}

You can specify just the initial letter.}

\item{pairwise.comparisons}{whether pairwise comparison}

\item{p.adjust.method}{Adjustment method for \emph{p}-values for multiple
comparisons. Possible methods are: \code{"holm"} (default), \code{"hochberg"},
\code{"hommel"}, \code{"bonferroni"}, \code{"BH"}, \code{"BY"}, \code{"fdr"}, \code{"none"}.}

\item{ggtheme}{A \code{{ggplot2}} theme. Default value is
\code{\link[ggstatsplot:theme_ggstatsplot]{theme_ggstatsplot()}}. Any of the \code{{ggplot2}} themes (e.g.,
\code{\link[ggplot2:ggtheme]{ggplot2::theme_bw()}}), or themes from extension packages are allowed
(e.g., \code{ggthemes::theme_fivethirtyeight()}, \code{hrbrthemes::theme_ipsum_ps()},
etc.). But note that sometimes these themes will remove some of the details
that \code{{ggstatsplot}} plots typically contains. For example, if relevant,
\code{\link[ggstatsplot:ggbetweenstats]{ggbetweenstats()}} shows details about multiple comparison test as a
label on the secondary Y-axis. Some themes (e.g.
\code{ggthemes::theme_fivethirtyeight()}) will remove the secondary Y-axis and
thus the details as well.}

\item{...}{other parameters passing to \link[ggstatsplot:ggbetweenstats]{ggstatsplot::ggbetweenstats} or \link[ggstatsplot:ggwithinstats]{ggstatsplot::ggwithinstats}.}
}
\value{
a (gg)plot object.
}
\description{
NOTE: the dataset must be dense matrix in UCSC Xena data hubs.
}
\examples{
\dontrun{
library(UCSCXenaTools)
expr_dataset <- "TCGA.LUAD.sampleMap/HiSeqV2_percentile"
cli_dataset <- "TCGA.LUAD.sampleMap/LUAD_clinicalMatrix"
id <- "TP53"
cli_df <- XenaGenerate(
  subset = XenaDatasets == "TCGA.LUAD.sampleMap/LUAD_clinicalMatrix"
) \%>\%
  XenaQuery() \%>\%
  XenaDownload() \%>\%
  XenaPrepare()

# group data.frame with 2 columns
vis_identifier_grp_comparison(expr_dataset, id, cli_df[, c("sampleID", "gender")])
# group data.frame with 3 columns
vis_identifier_grp_comparison(
  expr_dataset, id,
  cli_df[, c("sampleID", "pathologic_M", "gender")] \%>\%
    dplyr::filter(pathologic_M \%in\% c("M0", "MX"))
)

# When not use the value of `identifier` from `dataset`
vis_identifier_grp_comparison(grp_df = cli_df[, c(1, 2, 71)])
vis_identifier_grp_comparison(grp_df = cli_df[, c(1, 2, 71, 111)])
}

}
