% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trueskillthroughtime.R
\name{Game}
\alias{Game}
\alias{posteriors}
\alias{posteriors,Game-method}
\title{Game}
\usage{
Game(teams, result = vector(), p_draw = P_DRAW)

posteriors(g)

\S4method{posteriors}{Game}(g)
}
\arguments{
\item{teams}{A list of \code{Player} objects. Each position represents a team,
so it must contain a vector of \code{Player} objects.}

\item{result}{A vector of numbers, with the score obtained by each team, or
an empty vector. The default value is an empty vector. In this case, the
outcome is defined by the order in which the \code{teams} list was initialized:
the teams appearing firstly in the list defeat those appearing later (no ties). If 
the list is not empty, it must have the same length as the \code{teams} list. In 
this last case, the team with the highest score is the winner, and the teams with 
the same score are tied.}

\item{p_draw}{A number, the probability of a draw. The default value is 
\code{P_DRAW = 0}. A rule of thumb states that the probability of a draw must be 
initialized with the observed frequency of draws. If in doubt, it is a candidate 
parameter to be optimized or integrated by the sum rule. It is used to compute 
the prior probability of the observed result, so its value may affect an 
eventual model selection task.}

\item{g}{A game object}
}
\value{
Game object
}
\description{
Game class
}
\examples{
a1 = Player(Gaussian(mu=0, sigma=6), beta=1, gamma=0.03)
a2 = Player(); a3 = Player(); a4 = Player()
team_a = c(a1, a2)
team_b = c(a3, a4)
teams = list(team_a, team_b)

g = Game(teams) 
post = posteriors(g)
lhs = g@likelihoods
post[[1]][[1]] == lhs[[1]][[1]]*a1@prior 
ev = g@evidence
ev == 0.5

ta = c(a1)
tb = c(a2, a3)
tc = c(a4)
teams_3 = list(ta, tb, tc)
result = c(1, 0, 0)
g3 = Game(teams_3, result, p_draw=0.25)

}
