% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{check_date_ts}
\alias{check_date_ts}
\alias{assert_date_ts}
\title{Vérifie le format de date}
\usage{
check_date_ts(x, frequency_ts, .var.name = checkmate::vname(x), warn = TRUE)

assert_date_ts(
  x,
  frequency_ts,
  add = NULL,
  .var.name = checkmate::vname(x),
  warn = TRUE
)
}
\arguments{
\item{x}{un vecteur numérique, de préférence \code{integer} au format \code{AAAA},
\code{c(AAAA, MM)} ou \code{c(AAAA, TT)}}

\item{frequency_ts}{un entier qui vaut \code{4L} (ou \code{4.0}) pour les séries
trimestrielles et \code{12L} (ou \code{12.0}) pour les séries mensuelles.}

\item{.var.name}{Nom de l'objet à vérifier pour afficher dans les messages}

\item{warn}{un booleen}

\item{add}{Collection pour stocker les messages d'erreurs (Default is NULL)}
}
\value{
En sortie la fonction retourne l'objet \code{x} de manière invisible ou
une erreur.
}
\description{
La fonction \code{assert_date_ts} vérifie qu'un objet est de type
\code{AAAA}, \code{c(AAAA, MM)} ou \code{c(AAAA, TT)}
}
\details{
Les fonctions du package TractorTsbox sont faites pour fonctionner
avec des times-series de fréquence mensuelle ou trimestrielle et basés sur le
système des mois, trimestres et années classiques.
On cherche donc à favoriser l'utilisation de vecteur \code{c(AAAA, MM)} pour
désigner la date choisie.
Lorsque l'objet \code{x} en entrée est au mauvais format, il est corrigé pendant
la vérification et l'objet en sortie est au bon format.
Si l'argument \code{warn} est \code{FALSE}, alors la fonction ne retournera pas de
warning lors de l'évaluation.

Ici, l'argument \code{frequency_ts} est nécessaire car une date sous la forme
c(AAAA, PP), avec PP le nombre de période, ne désigne pas une date absolue.
Par exemple, c(2020L 5L) désigne mai 2020 pour une fréquence mensuelle et le
1er trimestre 2021 pour une fréquence trimestrielle.

Selon le préfixe de la fonction :

\itemize{
\item si le check réussi : \itemize{
\item la fonction \code{assert_date_ts} retourne l'objet \code{x} de manière invisible;
\item la fonction \code{check_date_ts} retourne le booléen \code{TRUE}.
}
\item si le check échoue : \itemize{
\item la fonction \code{assert_date_ts} retourne un message d'erreur;
\item la fonction \code{check_date_ts} retourne une chaîne de caractère signalant le problème.
}
}
}
\examples{
# De bons formats de date
assert_date_ts(c(2020L, 8L), frequency_ts = 12L)
assert_date_ts(c(2020L, 2L), frequency_ts = 4L)
check_date_ts(2022L, frequency_ts = 12L)

# Format double --> génération d'un warning
assert_date_ts(c(2020., 4.0), frequency_ts = 4L)
assert_date_ts(2022., frequency_ts = 12L)
check_date_ts(2022., frequency_ts = 12L)

# Fréquence au format double --> génération d'un warning
assert_date_ts(c(2020L, 6L), frequency_ts = 4.0)
assert_date_ts(c(2020L, 42L), frequency_ts = 12.0)

# Dépassement la fréquence --> génération d'un warning
assert_date_ts(c(2020L, 6L), frequency_ts = 4L)
assert_date_ts(c(2020L, 42L), frequency_ts = 12L)
assert_date_ts(c(2020L, -4L), frequency_ts = 12L)

# Avec des erreurs
check_date_ts(1:10, frequency_ts = 12L)

}
