% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.TSVC.R
\name{confint.TSVC}
\alias{confint.TSVC}
\title{Confidence intervals for Varying Coefficient Trees}
\usage{
\method{confint}{TSVC}(
  object,
  bootstrap_n = 500,
  alpha = 0.05,
  post_pruning = NULL,
  splits_max = 5,
  trace = FALSE,
  ...
)
}
\arguments{
\item{object}{a fitted object of class \code{\link[TSVC]{TSVC}}.}

\item{bootstrap_n}{the number of bootstrap samples to be drawn.}

\item{alpha}{significance level \eqn{alpha} of the confidence interval.}

\item{post_pruning}{method to select the maximal number of splits; can be \code{"AIC"} or \code{"BIC"}. If \code{NULL} (default), no post-pruning is performed.}

\item{splits_max}{maximal number of splits to be considered. If \code{post_pruning} is \code{NULL} it is ignored.}

\item{trace}{if \code{TRUE}, information about the estimation progress is printed.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Construct parametric bootstrap percentile confidence intervals of effects of covariates that vary with the values of one or several effect modifiers. The basic method 
is described in Spuck et al. (2025).
}
\details{
The method is so far mainly put to the test for gaussian (family=gaussian) and binary (family=binary(link="logit")) outcome. It should be taken with care for 
differently scaled outcomes.
}
\examples{
# Swiss Labour Market 
library(AER)
data("SwissLabor")

# recode factors 
sl <- SwissLabor
sl$participation <- as.numeric(sl$participation)-1
sl$foreign       <- as.numeric(sl$foreign)-1

\dontrun{
fit1 <- TSVC(participation~income+age, data=sl, family=binomial(link="logit"), 
perm_test=FALSE, test_linear=FALSE, splits_max=3)
confint(fit1, bootstrap_n=500, alpha=0.05, trace=TRUE)
}

}
\references{
Berger, M., G. Tutz and M. Schmid (2019). Tree-Structured Modelling of Varying Coefficients. Statistics and Computing 29, 217-229,
https://doi.org/10.1007/s11222-018-9804-8. 

Spuck, N., M. Schmid, M. Monin and M. Berger (2025). Confidence intervals for tree-structured varying coefficients. Computational Statistics and Data Analysis.
}
\seealso{
\code{\link[TSVC]{TSVC}}, \code{\link[TSVC]{plot.TSVC}}, \code{\link[TSVC]{predict.TSVC}}, \code{\link[TSVC]{summary.TSVC}}
}
\author{
Moritz Berger <Moritz.Berger@imbie.uni-bonn.de> \cr \url{https://www.imbie.uni-bonn.de/people/dr-moritz-berger/} 

Nikolai Spuck <Spuck@imbie.uni-bonn.de> \cr \url{https://www.imbie.uni-bonn.de/people/nikolai-spuck/}
}
