% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSLSTM.R
\name{minmax_scale}
\alias{minmax_scale}
\title{Min-Max Scaling of a Matrix}
\usage{
minmax_scale(x, min = TRUE, range = TRUE)
}
\arguments{
\item{x}{A numeric matrix whose columns are to be scaled.}

\item{min}{Logical or numeric vector. If `TRUE`, the minimum value of each column is subtracted.
If a numeric vector is provided, it must have a length equal to the number of columns in `x`,
and these values are subtracted from each corresponding column.}

\item{range}{Logical or numeric vector. If `TRUE`, each column is divided by its range.
If a numeric vector is provided, it must have a length equal to the number of columns in `x`,
and each column is divided by the corresponding value in this vector.}
}
\value{
A matrix with the same dimensions as `x`, where each column has been scaled according to the min-max scaling process.
}
\description{
This function applies min-max scaling to a matrix. Each column of the matrix is scaled independently.
The scaling process transforms the values in each column to a specified range, typically [0, 1]. The function
subtracts the minimum value of each column (if `min` is `TRUE` or a numeric vector) and then divides by the range
of each column (if `range` is `TRUE` or a numeric vector).
}
\examples{
\donttest{
  data <- matrix(rnorm(100), ncol = 10)
  scaled_data <- minmax_scale(data)
}

}
