% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expansion.R
\name{getetmat}
\alias{getetmat}
\title{Tree-guided expansion}
\usage{
getetmat(tmatrix, dmatrix)
}
\arguments{
\item{tmatrix}{Tree structure of the original features in matrix form.}

\item{dmatrix}{Original design matrix in matrix form.}
}
\value{
A list.
\item{x.expand}{The design matrix after expansion.
Each column is multiplied by \eqn{(-1)^{r-1}},
where r is the order of the corresponding interaction term.}
\item{tree.expand}{The tree structure after expansion.}
\item{x.expand.adj}{The design matrix after expansion with the
effects of signs removed.}
}
\description{
Give the expanded design matrix and the expanded tree structure
by adding interactions in conformity to the structure.
}
\details{
This function is used by the TSLA method only when the \code{penalty} is
selected as "CL2". The all zero columns produced by the
interactions are excluded in the output.

For the TSLA method, the signs of the coefficients in the linear
constraints depend on the order of the term.
To better extend the method in implementation, we apply the signs on
the feature vectors instead of the regression coefficients.
For example, we use feature vector -\eqn{x_{12}} instead of \eqn{x_{12}}.
The expanded design matrix \code{x.expand} from this
function is adjusted by the signs. The \code{A} matrix and
all the coefficients estimated from the package
can be explained correspondingly. We also provide \code{x.expand.adj},
\code{A.adj}, and \code{beta.coef.adj}
as the quantities with the effects of the signs removed.


The input tree structure of the original features needs to be
constructed as the following:
each row corresponds to a variable at the finest level;
each column corresponds to an ordered classification level with the
leaf level at the left-most and the root level at the right-most;
the entry values in each column are the index of the ancestor node of
the variable at that level.
As we move from left to right, the number of unique values
in the column becomes fewer.
}
