% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrePLT.R
\name{etatidy}
\alias{etatidy}
\title{Tidy eta table for further process}
\usage{
etatidy(x)
}
\arguments{
\item{x}{A calculation result returned from the function \code{\link[TPMplt:DMMprocess]{DMMprocess}}.}
}
\value{
A matrix with melted temperatures, logarithm strain rates and values of power dissipation factor
in respective columns.
}
\description{
Tidy the table of power dissipation efficiency factor eta, with different logarithm strain
rates and temperature for further analysis, based on the given dynamic material model.
}
\examples{
epstable <- epsExtract(TPMdata, 0.7, 2, 3)
DMM <- DMMprocess(epstable)
etaM <- etatidy(DMM)
etaM
}
\seealso{
\code{\link[TPMplt:xitidy]{xitidy}}, \code{\link[TPMplt:DMMprocess]{DMMprocess}}
}
\keyword{internal}
