% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_diag2silhouette.R
\name{diag2silhouette}
\alias{diag2silhouette}
\title{Convert Persistence Diagram into Persistent Silhouette}
\usage{
diag2silhouette(homology, dimension = 1, p = 2, nseq = 100)
}
\arguments{
\item{homology}{an object of S3 class \code{"homology"} generated from \code{diagRips} or other diagram-generating functions.}

\item{dimension}{dimension of features to be considered (default: 1).}

\item{p}{an exponent for the weight function of form \eqn{|a-b|^p} (default: 2).}

\item{nseq}{grid size for which the landscape function is evaluated.}
}
\value{
a list object of \code{"silhouette"} class containing\describe{
\item{lambda}{an \eqn{(\code{nseq} \times k)} landscape functions.}
\item{tseq}{a length-\code{nseq} vector of domain grid.}
\item{dimension}{dimension of features considered.}
}
}
\description{
Persistence Silhouette (PS) is a functional summary of persistent homology 
that is constructed given a \code{homology} object. PS is a weighted average of 
landscape functions so that it becomes a uni-dimensional function.
}
\examples{
# ---------------------------------------------------------------------------
#              Persistence Silhouette of 'iris' Dataset
#
# We will extract silhouettes of dimensions 0, 1, and 2.
# ---------------------------------------------------------------------------
## Prepare 'iris' data
XX = as.matrix(iris[,1:4])

## Compute Persistence Diagram 
pdrips = diagRips(XX, maxdim=2)

## Convert to Silhouettes of Each Dimension
sil0 <- diag2silhouette(pdrips, dimension=0)
sil1 <- diag2silhouette(pdrips, dimension=1)
sil2 <- diag2silhouette(pdrips, dimension=2)

## Visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(2,2))
plot(pdrips$Birth, pdrips$Death, col=as.factor(pdrips$Dimension),
     pch=19, main="persistence diagram", xlab="Birth", ylab="Death")
plot(sil0$tseq, sil0$lambda, type="l", lwd=3, main="dimension 0", xlab="t")
plot(sil1$tseq, sil1$lambda, type="l", lwd=3, main="dimension 1", xlab="t")
plot(sil2$tseq, sil2$lambda, type="l", lwd=3, main="dimension 2", xlab="t")
par(opar)

}
\concept{convert}
