% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facet.R
\name{sp_facet}
\alias{sp_facet}
\title{Create Multiple Charts Based on a Faceting Variable}
\usage{
sp_facet(sp, ncol = NULL, nrow = NULL, scales = "fixed")
}
\arguments{
\item{sp}{A SveltePlot htmlwidget object.}

\item{ncol}{The number of columns in the facet grid. Default is NULL, which auto-calculates based on the number of rows.}

\item{nrow}{The number of rows in the facet grid. Default is NULL, which auto-calculates based on the number of columns.}

\item{scales}{A character string specifying whether scales are shared across all facets. Options are "fixed" (default) or "free".}
}
\value{
An object of class \code{htmlwidget} representing the facetted plot.
}
\description{
This function creates multiple charts based on a specified faceting variable.
}
\details{
This function splits the data by the specified facet variable and creates multiple charts (facets) accordingly.
The function can automatically determine the number of rows and columns in the facet grid if not specified.
}
\examples{
library(SveltePlots)
data("penguins")
sp <- sp(
  data = penguins,
  mapping = spaes(x = flipper_length_mm, y = bill_length_mm, group = species),
  type = "points",
  facet_var = "sex"
) |>
  SveltePlots::sp_facet(ncol = 2, scales = "free")
sp
}
