
// Mathematical constants computed using Wolfram Alpha
#define MATH_PI        3.141592653589793238462643383279502884197169399375105820974
#define MATH_PI_2      1.570796326794896619231321691639751442098584699687552910487
#define MATH_2_PI      0.636619772367581343075535053490057448137838582961825794990
#define MATH_PI2       9.869604401089358618834490999876151135313699407240790626413
#define MATH_PI2_2     4.934802200544679309417245499938075567656849703620395313206
#define MATH_SQRT1_2   0.707106781186547524400844362104849039284835937688474036588
#define MATH_SQRT_PI_2 1.253314137315500251207882642405522626503493370304969158314
#define MATH_LOG_PI    1.144729885849400174143427351353058711647294812915311571513
#define MATH_LOG_2_PI  -0.45158270528945486472619522989488214357179467855505631739
#define MATH_LOG_PI_2  0.451582705289454864726195229894882143571794678555056317392

// Function prototypes
arma::mat mvrnorm_arma(int n, const arma::vec& mu, const arma::mat& sigma);
arma::mat make_Z(const arma::mat X, const arma::mat Y, const std::string method);
double logit(double x);
arma::mat vec_2_mat(arma::vec X, const int nrow, const int ncol);
arma::mat vec_2_mat_byrow(arma::vec X, const int nrow, const int ncol);
arma::uvec find_observed(arma::mat X);
arma::uvec find_unobserved(arma::mat X);
double rcpp_pgdraw(int b, double c);
double samplepg(double z);
double exprnd(double mu);
double tinvgauss(double z, double t);
double truncgamma();
double randinvg(double mu);
double aterm(int n, double x, double t);
