% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newick.R
\name{newick_string}
\alias{newick_string}
\title{Generate Newick Tree Format Parenthetic Strings}
\usage{
newick_string(
  x = NULL,
  level = c("suborder", "greatgroup", "subgroup"),
  what = c("taxon", "code")
)
}
\arguments{
\item{x}{Optional: a taxon name to get children of.}

\item{level}{Level to build the tree at. One of \code{"suborder"}, \code{"greatgroup"}, \code{"subgroup"}. Defaults to \code{"suborder"} when \code{x} is not specified. When \code{x} is specified but \code{level} is not specified, \code{level} is calculated from \code{taxon_to_level(x)}.}

\item{what}{Either \code{"taxon"} (default; for taxon names (quoted for subgroups)) or \code{"code"}}
}
\value{
character. A single tree in parenthetical Newick or New Hampshire format.
}
\description{
This function generates \href{https://en.wikipedia.org/wiki/Newick_format}{Newick tree format} strings for a single tree. Taxa are assigned relative positions within their parent to indicate the order that they "key out."
}
\details{
The output from this function is a character string with parenthetical format encoding a single tree suitable for input into functions such as \code{ape::read.tree()}. Multiple trees can be combined together in the file or text string supplied to your tree-parsing function of choice.
}
\examples{
if (requireNamespace("ape")) {
  par(mar = c(0, 0, 0, 0))

  # "fan"
  mytr <- ape::read.tree(text = newick_string(level = "suborder"))
  plot(mytr, "f", rotate.tree = 180, cex = 0.75)

  # "cladogram"
  mytr <- ape::read.tree(text = newick_string("durixeralfs", level = "subgroup"))
  plot(mytr, "c")

  # "cladogram" (using taxon codes instead of subgroups)
  mytr <- ape::read.tree(text = newick_string("xeralfs", level = "subgroup", what = "code"))
  plot(mytr, "c")

  dev.off()
}
}
