% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin.R
\name{bin_metadata}
\alias{bin_metadata}
\title{Spatio-molecular binning of relative expression intensities}
\usage{
bin_metadata(
  md,
  dat,
  avg_bead_per_bin = 12,
  pos = TRUE,
  pos_k = 55,
  ex_k = 1,
  hc_function = "ward.D2",
  plot_directory
)
}
\arguments{
\item{md}{data.table of metadata of each bead}

\item{dat}{data.table of smoothed relative expression intensities}

\item{avg_bead_per_bin}{integer of average number of beads there should be per bin}

\item{pos}{TRUE if doing spatial and expressional binning, FALSE if just expressional binning}

\item{pos_k}{positional weight}

\item{ex_k}{expressional weight}

\item{hc_function}{hierarchical clustering function}

\item{plot_directory}{output plot directory path}
}
\value{
A data.table of bead metadata combined with binned expression intensities for all genes for all beads
}
\description{
This function combines metadata with binned relative expression intensities
}
