% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aa_generics.R, R/class_MPs.R, R/class_Slick.R
\docType{methods}
\name{MPs}
\alias{MPs}
\alias{MPs<-}
\alias{MPs,missing-method}
\alias{MPs,character_list-method}
\alias{MPs,Slick-method}
\alias{MPs<-,Slick-method}
\title{Methods for Creating, Accessing and Assigning \code{MPs} objects}
\usage{
MPs(Code = "", Label = "", Description = "", Color = "", Preset = list())

MPs(object) <- value

\S4method{MPs}{missing}()

\S4method{MPs}{character_list}(Code = "", Label = "", Description = "", Color = "", Preset = list())

\S4method{MPs}{Slick}(Code)

\S4method{MPs}{Slick}(object) <- value
}
\arguments{
\item{Code}{A \emph{short} code for the Management Procedures in this \code{Slick} object.
A character string length \code{nMP} or a named list for multi-language support. See \code{Details}}

\item{Label}{A short label for the  Management Procedures in this \code{Slick} object.
Can be longer than \code{Code} but recommended to keep short as possible so it shows clearly in plots and tables.
A character string length \code{nMP} or a named list for multi-language support. See \code{Details}}

\item{Description}{A description for the Management Procedures in this \code{Slick} object.
Can include Markdown, see \code{Examples}.
A character string length \code{nMP} or a named list for multi-language support. See \code{Details}}

\item{Color}{A character vector of colors for the MPs.}

\item{Preset}{An optional named list for the preset buttons in the \code{\link[=App]{App()}}. The name of the list
element will appear as a button in the \code{\link[=App]{App()}}.

Use \code{\link[=Code]{Code()}}, \code{\link[=Label]{Label()}}, \code{\link[=Description]{Description()}}, and \code{\link[=Preset]{Preset()}} to access
and assign the values for an existing \code{MPs} object, see \code{Examples}.}

\item{object}{A \code{\link[=Slick-class]{Slick-class()}} object}

\item{value}{A \code{\link[=MPs-class]{MPs-class()}} object}
}
\description{
The \code{MPs} function is used both to create and modify an \code{\link[=MPs-class]{MPs-class()}} object.
and to access and assign \code{MPs} for an object of class \code{\link[=Slick-class]{Slick-class()}}.
See \code{Details}.
}
\details{
Objects of class \code{MPs} are created with \code{MPs()}
}
\section{Functions}{
\itemize{
\item \code{MPs(missing)}: Create an empty \code{MPs} object

\item \code{MPs(character_list)}: Create a populated \code{MPs} object

\item \code{MPs(Slick)}: Return an \code{\link[=MPs-class]{MPs-class()}} object from a \code{\link[=Slick]{Slick()}} object

\item \code{MPs(Slick) <- value}: Assign an \code{\link[=MPs-class]{MPs-class()}} object to a \code{\link[=Slick]{Slick()}} object

}}
\examples{

myMPs <- MPs()
Code(myMPs) <- c('MP1', 'MP2', 'MP3')
Label(myMPs) <- c('Management Procedure 1',
                  'Management Procedure 2',
                  'Management Procedure 3')
Description(myMPs) <- c('This is the description for Management Procedure 1',
                        'This is the description for Management Procedure 2',
                        'This is the description for Management Procedure 3')

Preset(myMPs) <- list(All=1:3, FirstTwo=1:2)


myMPs

# Multi-language
Description(myMPs) <- list(en=c('This is the English description for Management Procedure 1',
                             'This is the English description for Management Procedure 2',
                             'This is the English description for Management Procedure 3'),
                           es=c("This is the Spanish description for Management Procedure 1",
                             "This is the Spanish description for Management Procedure 2",
                             "This is the Spanish description for Management Procedure 3"),
                           fr=c("This is the French description for Management Procedure 1",
                             "This is the French description for Management Procedure 2",
                             "This is the French description for Management Procedure 3")
                           )

Metadata(myMPs)
Metadata(myMPs, 'es')
Metadata(myMPs, 'fr')
}
\seealso{
\code{\link[=Code]{Code()}}, \code{\link[=Label]{Label()}}, \code{\link[=Description]{Description()}}, \code{\link[=Color]{Color()}}, \code{\link[=Metadata]{Metadata()}}, \code{\link[=Preset]{Preset()}}
}
