% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleSize_Mielke.R
\name{sign_Mielke}
\alias{sign_Mielke}
\title{Simulated Test Statistic for Noninferiority/Equivalence Trials}
\usage{
sign_Mielke(
  N,
  m,
  k,
  R,
  sigma,
  true.diff,
  equi.tol = log(1.25),
  design,
  alpha = 0.05,
  adjust = "no"
)
}
\arguments{
\item{N}{Integer specifying the number of subjects per sequence.}

\item{m}{Integer specifying the number of endpoints.}

\item{k}{Integer specifying the number of endpoints that must meet equivalence
to consider the test successful.}

\item{R}{Matrix specifying the correlation structure between endpoints.
This should be an \code{m x m} matrix, e.g., generated using \code{variance.const.corr()}.}

\item{sigma}{Numeric specifying the standard deviation of endpoints.
Can be a vector of length \code{m} (one per endpoint) or a single value.
In a 2x2 crossover design, this represents within-subject variance.
In a parallel-group design, it represents the treatment group standard deviation.}

\item{true.diff}{Numeric specifying the assumed true difference between test and reference.
Can be a vector of length \code{m} or a single value.}

\item{equi.tol}{Numeric specifying the equivalence margins.
The interval is defined as \code{(-equi.tol, +equi.tol)}.}

\item{design}{Character specifying the study design.
Options are \code{"22co"} for a 2x2 crossover design or \code{"parallel"} for a parallel-group design.}

\item{alpha}{Numeric specifying the significance level.}

\item{adjust}{Character specifying the method for multiplicity adjustment.
Options include \code{"no"} for no adjustment, \code{"bon"} for Bonferroni correction,
and \code{"k"} for k-adjustment.}
}
\value{
A numeric vector representing a realization of the simulated test statistic for the given setting.
}
\description{
Simulates test statistics for multiple hypothesis testing in biosimilar development,
following the approach described by Mielke et al. (2018). It calculates the necessary
sample size for meeting equivalence criteria across multiple endpoints while
considering correlation structures and applying multiplicity adjustments.
}
\details{
This function is designed for multiple-endpoint clinical trials, where success
is defined as meeting equivalence criteria for at least a subset of tests.
Simulated test statistics are based on multivariate normal distribution assumptions,
and the function supports k-out-of-m success criteria for regulatory approval.

Type I error control is achieved through multiplicity adjustments as proposed by
Lehmann and Romano (2005) to ensure rigorous error rate management. This approach
is particularly relevant for biosimilar studies, where sample size estimation must
account for multiple comparisons across endpoints, doses, or populations.
}
\references{
Kong, L., Kohberger, R. C., & Koch, G. G. (2004). Type I Error and Power in
Noninferiority/Equivalence Trials with Correlated Multiple Endpoints: An Example
from Vaccine Development Trials. \emph{Journal of Biopharmaceutical Statistics, 14}(4), 893–907.

Lehmann, E. L., & Romano, J. P. (2005). Generalizations of the Familywise Error Rate.
\emph{The Annals of Statistics, 33}(2), 1138–1154.

Mielke, J., Jones, B., Jilma, B., & König, F. (2018). Sample Size for Multiple
Hypothesis Testing in Biosimilar Development. \emph{Statistics in Biopharmaceutical Research, 10}(1), 39–49.
}
\keyword{internal}
