% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyse_group_sequential.R
\name{analyse_group_sequential}
\alias{analyse_group_sequential}
\alias{summarise_group_sequential}
\title{Create Analyse Functions for Group Sequential Design}
\usage{
analyse_group_sequential(followup, followup_type, alpha, analyse_functions)

summarise_group_sequential(name = NULL)
}
\arguments{
\item{followup}{followup events or time}

\item{followup_type}{"events" or "time"}

\item{alpha}{nominal alpha at each stage}

\item{analyse_functions}{analyse function or list of analyse functions}

\item{name}{name attribute of the returned closure}
}
\value{
an analyse function that can be used in runSimulation

Returns a function with the arguments:
\itemize{
\item condition
\item results
\item fixed objects
}

that can be passed to create_summarise_function or to
SimDesign::runSimulation and that returns a \code{data.frame}.
}
\description{
Create Analyse Functions for Group Sequential Design

Summarise Output from Analyse Functions for Group Sequential Design
}
\details{
\code{followup}, \code{followup_type} and \code{alpha} are evaluated for every simulated
dataset, i.e. the arguments to the Analyse function are available,
expressions like \code{followup=c(condition$interim, condition$max_followup)} are
valid arguments.

analyse_functions should take arguments condition, dataset and fixed_objects
and return a list conatining p-value, number of patients and number of event
in the columsn \code{p}, \code{N_pat} and \code{N_evt}.
}
\section{Functions}{
\itemize{
\item \code{summarise_group_sequential()}: Summarise Output from Analyse Functions for Group Sequential Design

}}
\examples{
# create a function to analyse after interim_events and maximum followup time
# given in the condition row of the design data.frame with given
# nominal alpha
analyse_maxcombo_sequential <- analyse_group_sequential(
  followup = c(condition$interim_events, condition$followup),
  followup_type = c("event", "time"),
  alpha = c(0.025, 0.05),
  analyse_functions = analyse_maxcombo()
)
Summarise <- create_summarise_function(
  maxcombo_seq = summarise_group_sequential(),
  logrank_seq = summarise_group_sequential(name="logrank")
)
}
