% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wordlist_to_network.R
\name{wordlist_to_network}
\alias{wordlist_to_network}
\title{wordlist_to_network}
\usage{
wordlist_to_network(
  dat,
  wordcol,
  output = "dendrogram",
  dist_type = "embedding"
)
}
\arguments{
\item{dat}{dataframe with text in it (cleaned using clean_monologue_or_list function}

\item{wordcol}{quoted argument identifying column in dataframe with target text}

\item{output}{quoted argument for type of output default is 'dendrogram', alternate is 'network'}

\item{dist_type}{quoted argument semantic norms for running distance matrix on default='embedding', other is 'SD15'}
}
\value{
a plot of a dendrogram or an igraph network AND a cosine distance matrix
}
\description{
Takes a vector of words with semantic distance ratings, converts to a square matrix, then to a euclidean distance
matrix (all word pairs), then plots the words in either a cluster dendrogram or simple igraph network
}
\details{
This function internally calls eval_kmeans_clustersize for
cluster evaluation. The dendrogram visualization is based on hierarchical
clustering of semantic distances.
}
