% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_v6_skip_transformation}
\alias{seasonder_v6_skip_transformation}
\title{Trigger Restart for Skipping Transformation}
\usage{
seasonder_v6_skip_transformation(cond, value)
}
\arguments{
\item{cond}{The condition object that triggered the restart.}

\item{value}{The provided value to be used when the transformation is skipped.}
}
\value{
This function triggers a restart and does not return a usual value.
}
\description{
This function provides a mechanism to invoke a restart during the reading and
transformation process of the SeaSonde CS File Version 6 header. It allows users
to skip transformations that may have caused errors and proceed with a provided value.
}
\details{
This function specifically triggers the \code{seasonder_v6_skip_transformation} restart
that allows for skipping a block transformation in the reading process of the
SeaSonde CS File Version 6 header. When triggered, it logs an error message,
skips the problematic transformation, and returns the provided value for the block.
}
\section{Integration with SeaSonde CS File Reading}{


The restart mechanism of this function is integrated within the
\code{seasonder_readSeaSondeCSFileHeaderV6} function. If an error occurs during
the transformation process of a specific block, the restart provides users with
an option to skip the problematic transformation and proceed with a fallback value.
}

\examples{
# Example: Skip transformation using a restart handler
res <- withRestarts(
  seasonder_v6_skip_transformation(simpleError("test error"), "default"),
  seasonder_v6_skip_transformation = function(cond, value) value
)
print(res)
}
