% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_setSeaSondeRCS_MUSIC_interpolated_data}
\alias{seasonder_setSeaSondeRCS_MUSIC_interpolated_data}
\title{Set Interpolated MUSIC Data in a SeaSondeRCS Object}
\usage{
seasonder_setSeaSondeRCS_MUSIC_interpolated_data(
  seasonder_cs_object,
  interpolated_data
)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing cross-spectral and MUSIC data.}

\item{interpolated_data}{A data structure (typically a list or tibble) representing the interpolated cross-spectral data.
If \code{NULL}, the function uses \code{seasonder_MUSICInitInterpolatedData()} to initialize the structure.}
}
\value{
The updated \code{SeaSondeRCS} object with the \code{interpolated_data} field set in its MUSIC data attribute.
}
\description{
This function assigns the interpolated cross-spectral data to the MUSIC data attribute of a SeaSondeRCS object.
It stores the provided interpolated data into the \code{interpolated_data} field of the MUSIC data.
If no data is provided, it defaults to the output of \code{seasonder_MUSICInitInterpolatedData()}.
}
\details{
The function assigns the provided interpolated data (or initializes a new data structure) to the
\code{interpolated_data} field within the MUSIC data attribute. This structure is intended for use in further
MUSIC processing steps, where interpolated cross-spectral data is required for refining the estimation of Doppler bins.
}
