% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_setSeaSondeRCS_FOR_method}
\alias{seasonder_setSeaSondeRCS_FOR_method}
\title{Set First Order Region Processing Method for SeaSondeRCS Object}
\usage{
seasonder_setSeaSondeRCS_FOR_method(seasonder_cs_object, FOR_method)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object containing spectral and metadata information.}

\item{FOR_method}{A character string specifying the desired FOR processing method. Currently, only
\code{"SeaSonde"} is supported.}
}
\value{
The updated SeaSondeRCS object with the specified FOR processing method set.
}
\description{
This function sets the First Order Region (FOR) processing method for a SeaSondeRCS object.
It validates the provided method using \code{seasonder_validateFORMethod} and assigns it to the
object's \code{FOR_data} attribute under \code{FOR_method}.
}
\details{
The function first validates the provided method. If the method is valid, it is stored in the
\code{FOR_data} attribute of the SeaSondeRCS object under the \code{FOR_method} field. This setting
is later used in the processing workflow to guide FOR computation.
}
