% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_setNoiseLevelEstimationInterval}
\alias{seasonder_setNoiseLevelEstimationInterval}
\title{Set Noise Level Estimation Interval for a SeaSondeRCS Object}
\usage{
seasonder_setNoiseLevelEstimationInterval(seasonder_cs_object, interval_value)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object.}

\item{interval_value}{A list containing the noise level estimation interval with two elements:
\itemize{
\item \code{low_limit}: A numeric value between 0 and 1 representing the lower limit.
\item \code{high_limit}: A numeric value between 0 and 1 representing the upper limit.
}
The \code{low_limit} should be less than \code{high_limit}.}
}
\value{
The updated SeaSondeRCS object with the new noise level estimation interval and reference noise normalized limits.
}
\description{
This function sets the noise level estimation interval for a SeaSondeRCS object by updating the object's
attribute and recalculating the reference noise normalized limits. It then updates the FOR parameters with the new noise limits.
}
\details{
The function updates the attribute \code{"reference_noise_normalized_limits_estimation_interval"} of the SeaSondeRCS
object with \code{interval_value}. It then computes new reference noise normalized limits by calling
\code{seasonder_estimateReferenceNoiseNormalizedLimits} with the provided lower and upper limits.
Finally, it sets the new noise limits in the FOR parameters using \code{seasonder_setFORParameter}.
}
\examples{
new_interval <- list(low_limit = 0.9, high_limit = 1.0)
# Prepare a SeaSondeRCS object with valid data
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
cs_obj <- seasonder_createSeaSondeRCS(
  cs_file,
  specs_path = seasonder_defaultSpecsFilePath("CS"),
  seasonder_apm_object = apm_obj
)
cs_obj <- seasonder_setNoiseLevelEstimationInterval(cs_obj, new_interval)
print(attr(cs_obj, "reference_noise_normalized_limits_estimation_interval"))
noise_limits <- seasonder_getFOR_parameters(cs_obj)$reference_noise_normalized_limits
print(noise_limits)
}
